<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "job_card_f" table
 */
#[Entity]
#[Table(name: "job_card_f")]
class JobCardF extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "integer", nullable: true)]
    private ?int $works;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(type: "string", nullable: true)]
    private ?string $po;

    #[Column(name: "employee_id", type: "string")]
    private string $employeeId;

    #[Column(name: "lot_no", type: "string", nullable: true)]
    private ?string $lotNo;

    #[Column(type: "string", nullable: true)]
    private ?string $1;

    #[Column(type: "string", nullable: true)]
    private ?string $2;

    #[Column(type: "string", nullable: true)]
    private ?string $3;

    #[Column(type: "string", nullable: true)]
    private ?string $4;

    #[Column(type: "string", nullable: true)]
    private ?string $5;

    #[Column(type: "string", nullable: true)]
    private ?string $6;

    #[Column(type: "string", nullable: true)]
    private ?string $7;

    #[Column(type: "string", nullable: true)]
    private ?string $8;

    #[Column(type: "string", nullable: true)]
    private ?string $other1;

    #[Column(type: "string", nullable: true)]
    private ?string $other2;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "integer", nullable: true)]
    private ?int $updated;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "jc_no", type: "integer", nullable: true)]
    private ?int $jcNo;

    #[Column(name: "s_grp", type: "integer")]
    private int $sGrp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $item;

    #[Column(name: "batch_no", type: "string", nullable: true)]
    private ?string $batchNo;

    #[Column(type: "string")]
    private string $poid;

    #[Column(type: "float")]
    private float $quantity;

    #[Column(name: "pro_unit", type: "string", nullable: true)]
    private ?string $proUnit;

    public function __construct()
    {
        $this->grp = 1;
        $this->employeeId = "1001";
        $this->operator = 0;
        $this->updated = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getWorks(): ?int
    {
        return $this->works;
    }

    public function setWorks(?int $value): static
    {
        $this->works = $value;
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getPo(): ?string
    {
        return HtmlDecode($this->po);
    }

    public function setPo(?string $value): static
    {
        $this->po = RemoveXss($value);
        return $this;
    }

    public function getEmployeeId(): string
    {
        return HtmlDecode($this->employeeId);
    }

    public function setEmployeeId(string $value): static
    {
        $this->employeeId = RemoveXss($value);
        return $this;
    }

    public function getLotNo(): ?string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(?string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function get1(): ?string
    {
        return HtmlDecode($this->1);
    }

    public function set1(?string $value): static
    {
        $this->1 = RemoveXss($value);
        return $this;
    }

    public function get2(): ?string
    {
        return HtmlDecode($this->2);
    }

    public function set2(?string $value): static
    {
        $this->2 = RemoveXss($value);
        return $this;
    }

    public function get3(): ?string
    {
        return HtmlDecode($this->3);
    }

    public function set3(?string $value): static
    {
        $this->3 = RemoveXss($value);
        return $this;
    }

    public function get4(): ?string
    {
        return HtmlDecode($this->4);
    }

    public function set4(?string $value): static
    {
        $this->4 = RemoveXss($value);
        return $this;
    }

    public function get5(): ?string
    {
        return HtmlDecode($this->5);
    }

    public function set5(?string $value): static
    {
        $this->5 = RemoveXss($value);
        return $this;
    }

    public function get6(): ?string
    {
        return HtmlDecode($this->6);
    }

    public function set6(?string $value): static
    {
        $this->6 = RemoveXss($value);
        return $this;
    }

    public function get7(): ?string
    {
        return HtmlDecode($this->7);
    }

    public function set7(?string $value): static
    {
        $this->7 = RemoveXss($value);
        return $this;
    }

    public function get8(): ?string
    {
        return HtmlDecode($this->8);
    }

    public function set8(?string $value): static
    {
        $this->8 = RemoveXss($value);
        return $this;
    }

    public function getOther1(): ?string
    {
        return HtmlDecode($this->other1);
    }

    public function setOther1(?string $value): static
    {
        $this->other1 = RemoveXss($value);
        return $this;
    }

    public function getOther2(): ?string
    {
        return HtmlDecode($this->other2);
    }

    public function setOther2(?string $value): static
    {
        $this->other2 = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getUpdated(): ?int
    {
        return $this->updated;
    }

    public function setUpdated(?int $value): static
    {
        $this->updated = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getJcNo(): ?int
    {
        return $this->jcNo;
    }

    public function setJcNo(?int $value): static
    {
        $this->jcNo = $value;
        return $this;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getItem(): ?int
    {
        return $this->item;
    }

    public function setItem(?int $value): static
    {
        $this->item = $value;
        return $this;
    }

    public function getBatchNo(): ?string
    {
        return HtmlDecode($this->batchNo);
    }

    public function setBatchNo(?string $value): static
    {
        $this->batchNo = RemoveXss($value);
        return $this;
    }

    public function getPoid(): string
    {
        return HtmlDecode($this->poid);
    }

    public function setPoid(string $value): static
    {
        $this->poid = RemoveXss($value);
        return $this;
    }

    public function getQuantity(): float
    {
        return $this->quantity;
    }

    public function setQuantity(float $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getProUnit(): ?string
    {
        return HtmlDecode($this->proUnit);
    }

    public function setProUnit(?string $value): static
    {
        $this->proUnit = RemoveXss($value);
        return $this;
    }
}
