<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "job_card_description" table
 */
#[Entity]
#[Table(name: "job_card_description")]
class JobCardDescription extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $rid;

    #[Column(name: "packing_type", type: "smallint", nullable: true)]
    private ?int $packingType;

    #[Column(name: "size_wl", type: "string", nullable: true)]
    private ?string $sizeWl;

    #[Column(type: "string", nullable: true)]
    private ?string $1;

    #[Column(type: "string", nullable: true)]
    private ?string $2;

    #[Column(type: "string", nullable: true)]
    private ?string $3;

    #[Column(type: "string", nullable: true)]
    private ?string $4;

    #[Column(type: "string", nullable: true)]
    private ?string $5;

    #[Column(type: "string", nullable: true)]
    private ?string $6;

    #[Column(type: "string", nullable: true)]
    private ?string $7;

    #[Column(type: "string", nullable: true)]
    private ?string $8;

    #[Column(type: "string", nullable: true)]
    private ?string $other1;

    #[Column(type: "string", nullable: true)]
    private ?string $other2;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getRid(): ?int
    {
        return $this->rid;
    }

    public function setRid(?int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getSizeWl(): ?string
    {
        return HtmlDecode($this->sizeWl);
    }

    public function setSizeWl(?string $value): static
    {
        $this->sizeWl = RemoveXss($value);
        return $this;
    }

    public function get1(): ?string
    {
        return HtmlDecode($this->1);
    }

    public function set1(?string $value): static
    {
        $this->1 = RemoveXss($value);
        return $this;
    }

    public function get2(): ?string
    {
        return HtmlDecode($this->2);
    }

    public function set2(?string $value): static
    {
        $this->2 = RemoveXss($value);
        return $this;
    }

    public function get3(): ?string
    {
        return HtmlDecode($this->3);
    }

    public function set3(?string $value): static
    {
        $this->3 = RemoveXss($value);
        return $this;
    }

    public function get4(): ?string
    {
        return HtmlDecode($this->4);
    }

    public function set4(?string $value): static
    {
        $this->4 = RemoveXss($value);
        return $this;
    }

    public function get5(): ?string
    {
        return HtmlDecode($this->5);
    }

    public function set5(?string $value): static
    {
        $this->5 = RemoveXss($value);
        return $this;
    }

    public function get6(): ?string
    {
        return HtmlDecode($this->6);
    }

    public function set6(?string $value): static
    {
        $this->6 = RemoveXss($value);
        return $this;
    }

    public function get7(): ?string
    {
        return HtmlDecode($this->7);
    }

    public function set7(?string $value): static
    {
        $this->7 = RemoveXss($value);
        return $this;
    }

    public function get8(): ?string
    {
        return HtmlDecode($this->8);
    }

    public function set8(?string $value): static
    {
        $this->8 = RemoveXss($value);
        return $this;
    }

    public function getOther1(): ?string
    {
        return HtmlDecode($this->other1);
    }

    public function setOther1(?string $value): static
    {
        $this->other1 = RemoveXss($value);
        return $this;
    }

    public function getOther2(): ?string
    {
        return HtmlDecode($this->other2);
    }

    public function setOther2(?string $value): static
    {
        $this->other2 = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
