<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "job_card_bc" table
 */
#[Entity]
#[Table(name: "job_card_bc")]
class JobCardBc extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "integer", nullable: true)]
    private ?int $no;

    #[Column(type: "integer", nullable: true)]
    private ?int $works;

    #[Column(name: "issue_to", type: "integer", nullable: true)]
    private ?int $issueTo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(type: "string")]
    private string $po;

    #[Column(name: "design_size", type: "string", nullable: true)]
    private ?string $designSize;

    #[Column(name: "size_wl", type: "string")]
    private string $sizeWl;

    #[Column(name: "loom_no", type: "smallint", nullable: true)]
    private ?int $loomNo;

    #[Column(name: "employee_1", type: "smallint", nullable: true)]
    private ?int $employee1;

    #[Column(name: "employee_2", type: "smallint", nullable: true)]
    private ?int $employee2;

    #[Column(name: "employee_3", type: "smallint", nullable: true)]
    private ?int $employee3;

    #[Column(name: "employee_id", type: "string", nullable: true)]
    private ?string $employeeId;

    #[Column(type: "string", unique: true, nullable: true)]
    private ?string $barcode;

    #[Column(name: "r_date", type: "date", nullable: true)]
    private ?DateTime $rDate;

    #[Column(name: "lot_no", type: "string", nullable: true)]
    private ?string $lotNo;

    #[Column(type: "decimal")]
    private string $deduction;

    #[Column(name: "ded_remarks", type: "string", nullable: true)]
    private ?string $dedRemarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "integer", nullable: true)]
    private ?int $updated;

    #[Column(type: "string", nullable: true)]
    private ?string $1;

    #[Column(type: "string", nullable: true)]
    private ?string $2;

    #[Column(type: "string", nullable: true)]
    private ?string $3;

    #[Column(type: "string", nullable: true)]
    private ?string $4;

    #[Column(type: "string", nullable: true)]
    private ?string $5;

    #[Column(type: "string", nullable: true)]
    private ?string $6;

    #[Column(type: "string", nullable: true)]
    private ?string $7;

    #[Column(type: "string", nullable: true)]
    private ?string $8;

    #[Column(type: "string", nullable: true)]
    private ?string $other1;

    #[Column(type: "string", nullable: true)]
    private ?string $other2;

    public function __construct()
    {
        $this->no = 0;
        $this->works = (isset($_COOKIE["location"]))? $_COOKIE["location"]:User_Site();
        $this->issueTo = 0;
        $this->grp = (isset($_COOKIE["grp"]))? $_COOKIE["grp"]:'3';
        $this->sGrp = (isset($_COOKIE["s_grp"]))? $_COOKIE["s_grp"]:'91';
        $this->po = (isset($_COOKIE["po"]))? $_COOKIE["po"]:'';
        $this->employee2 = 10000;
        $this->employee3 = 10000;
        $this->deduction = "0.00";
        $this->operator = 0;
        $this->updated = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getNo(): ?int
    {
        return $this->no;
    }

    public function setNo(?int $value): static
    {
        $this->no = $value;
        return $this;
    }

    public function getWorks(): ?int
    {
        return $this->works;
    }

    public function setWorks(?int $value): static
    {
        $this->works = $value;
        return $this;
    }

    public function getIssueTo(): ?int
    {
        return $this->issueTo;
    }

    public function setIssueTo(?int $value): static
    {
        $this->issueTo = $value;
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getPo(): string
    {
        return HtmlDecode($this->po);
    }

    public function setPo(string $value): static
    {
        $this->po = RemoveXss($value);
        return $this;
    }

    public function getDesignSize(): ?string
    {
        return HtmlDecode($this->designSize);
    }

    public function setDesignSize(?string $value): static
    {
        $this->designSize = RemoveXss($value);
        return $this;
    }

    public function getSizeWl(): string
    {
        return HtmlDecode($this->sizeWl);
    }

    public function setSizeWl(string $value): static
    {
        $this->sizeWl = RemoveXss($value);
        return $this;
    }

    public function getLoomNo(): ?int
    {
        return $this->loomNo;
    }

    public function setLoomNo(?int $value): static
    {
        $this->loomNo = $value;
        return $this;
    }

    public function getEmployee1(): ?int
    {
        return $this->employee1;
    }

    public function setEmployee1(?int $value): static
    {
        $this->employee1 = $value;
        return $this;
    }

    public function getEmployee2(): ?int
    {
        return $this->employee2;
    }

    public function setEmployee2(?int $value): static
    {
        $this->employee2 = $value;
        return $this;
    }

    public function getEmployee3(): ?int
    {
        return $this->employee3;
    }

    public function setEmployee3(?int $value): static
    {
        $this->employee3 = $value;
        return $this;
    }

    public function getEmployeeId(): ?string
    {
        return HtmlDecode($this->employeeId);
    }

    public function setEmployeeId(?string $value): static
    {
        $this->employeeId = RemoveXss($value);
        return $this;
    }

    public function getBarcode(): ?string
    {
        return HtmlDecode($this->barcode);
    }

    public function setBarcode(?string $value): static
    {
        $this->barcode = RemoveXss($value);
        return $this;
    }

    public function getRDate(): ?DateTime
    {
        return $this->rDate;
    }

    public function setRDate(?DateTime $value): static
    {
        $this->rDate = $value;
        return $this;
    }

    public function getLotNo(): ?string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(?string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getDeduction(): string
    {
        return $this->deduction;
    }

    public function setDeduction(string $value): static
    {
        $this->deduction = $value;
        return $this;
    }

    public function getDedRemarks(): ?string
    {
        return HtmlDecode($this->dedRemarks);
    }

    public function setDedRemarks(?string $value): static
    {
        $this->dedRemarks = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getUpdated(): ?int
    {
        return $this->updated;
    }

    public function setUpdated(?int $value): static
    {
        $this->updated = $value;
        return $this;
    }

    public function get1(): ?string
    {
        return HtmlDecode($this->1);
    }

    public function set1(?string $value): static
    {
        $this->1 = RemoveXss($value);
        return $this;
    }

    public function get2(): ?string
    {
        return HtmlDecode($this->2);
    }

    public function set2(?string $value): static
    {
        $this->2 = RemoveXss($value);
        return $this;
    }

    public function get3(): ?string
    {
        return HtmlDecode($this->3);
    }

    public function set3(?string $value): static
    {
        $this->3 = RemoveXss($value);
        return $this;
    }

    public function get4(): ?string
    {
        return HtmlDecode($this->4);
    }

    public function set4(?string $value): static
    {
        $this->4 = RemoveXss($value);
        return $this;
    }

    public function get5(): ?string
    {
        return HtmlDecode($this->5);
    }

    public function set5(?string $value): static
    {
        $this->5 = RemoveXss($value);
        return $this;
    }

    public function get6(): ?string
    {
        return HtmlDecode($this->6);
    }

    public function set6(?string $value): static
    {
        $this->6 = RemoveXss($value);
        return $this;
    }

    public function get7(): ?string
    {
        return HtmlDecode($this->7);
    }

    public function set7(?string $value): static
    {
        $this->7 = RemoveXss($value);
        return $this;
    }

    public function get8(): ?string
    {
        return HtmlDecode($this->8);
    }

    public function set8(?string $value): static
    {
        $this->8 = RemoveXss($value);
        return $this;
    }

    public function getOther1(): ?string
    {
        return HtmlDecode($this->other1);
    }

    public function setOther1(?string $value): static
    {
        $this->other1 = RemoveXss($value);
        return $this;
    }

    public function getOther2(): ?string
    {
        return HtmlDecode($this->other2);
    }

    public function setOther2(?string $value): static
    {
        $this->other2 = RemoveXss($value);
        return $this;
    }
}
