<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "jc_mrlot" table
 */
#[Entity]
#[Table(name: "jc_mrlot")]
class JcMrlot extends AbstractEntity
{
    #[Column(type: "string", nullable: true)]
    private ?string $id;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(type: "string", nullable: true)]
    private ?string $packing;

    #[Column(name: "lot_no", type: "string", nullable: true)]
    private ?string $lotNo;

    #[Column(name: "Balance", type: "decimal", nullable: true)]
    private ?string $balance;

    public function getId(): ?string
    {
        return HtmlDecode($this->id);
    }

    public function setId(?string $value): static
    {
        $this->id = RemoveXss($value);
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getPacking(): ?string
    {
        return HtmlDecode($this->packing);
    }

    public function setPacking(?string $value): static
    {
        $this->packing = RemoveXss($value);
        return $this;
    }

    public function getLotNo(): ?string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(?string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getBalance(): ?string
    {
        return $this->balance;
    }

    public function setBalance(?string $value): static
    {
        $this->balance = $value;
        return $this;
    }
}
