<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "invoice_details" table
 */
#[Entity]
#[Table(name: "invoice_details")]
class InvoiceDetail extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "text", nullable: true)]
    private ?string $barcode;

    #[Column(type: "text", nullable: true)]
    private ?string $exporter;

    #[Column(type: "text", nullable: true)]
    private ?string $consignee;

    #[Column(name: "consignee_other", type: "text", nullable: true)]
    private ?string $consigneeOther;

    #[Column(name: "packing_list_no", type: "decimal", unique: true, nullable: true)]
    private ?string $packingListNo;

    #[Column(name: "d_11", type: "string", nullable: true)]
    private ?string $d11;

    #[Column(name: "description_11", type: "string", nullable: true)]
    private ?string $description11;

    #[Column(name: "in_template", type: "string", nullable: true)]
    private ?string $inTemplate;

    #[Column(name: "pl_template", type: "string", nullable: true)]
    private ?string $plTemplate;

    #[Column(name: "invoice_no", type: "string", nullable: true)]
    private ?string $invoiceNo;

    #[Column(name: "invoice_date", type: "datetime", nullable: true)]
    private ?DateTime $invoiceDate;

    #[Column(name: "po_no", type: "string", nullable: true)]
    private ?string $poNo;

    #[Column(name: "other_reference", type: "string", nullable: true)]
    private ?string $otherReference;

    #[Column(type: "string", nullable: true)]
    private ?string $origin;

    #[Column(name: "final_destination", type: "string", nullable: true)]
    private ?string $finalDestination;

    #[Column(name: "payment_terms", type: "string", nullable: true)]
    private ?string $paymentTerms;

    #[Column(name: "pre_carriage_receipt", type: "string", nullable: true)]
    private ?string $preCarriageReceipt;

    #[Column(name: "place_of_receipt", type: "string", nullable: true)]
    private ?string $placeOfReceipt;

    #[Column(name: "loading_port", type: "string", nullable: true)]
    private ?string $loadingPort;

    #[Column(name: "port_discharge", type: "string", nullable: true)]
    private ?string $portDischarge;

    #[Column(name: "d_01", type: "string", nullable: true)]
    private ?string $d01;

    #[Column(name: "description_01", type: "string", nullable: true)]
    private ?string $description01;

    #[Column(name: "d_02", type: "string", nullable: true)]
    private ?string $d02;

    #[Column(name: "description_02", type: "string", nullable: true)]
    private ?string $description02;

    #[Column(name: "gross_weight", type: "string", nullable: true)]
    private ?string $grossWeight;

    #[Column(name: "nett_weight", type: "string", nullable: true)]
    private ?string $nettWeight;

    #[Column(type: "string", nullable: true)]
    private ?string $cbm;

    #[Column(name: "exporter_bank_details", type: "string", nullable: true)]
    private ?string $exporterBankDetails;

    #[Column(name: "intermediary_bank", type: "string", nullable: true)]
    private ?string $intermediaryBank;

    #[Column(name: "shipment_mode", type: "smallint", nullable: true)]
    private ?int $shipmentMode;

    #[Column(name: "ex_factory_date", type: "date", nullable: true)]
    private ?DateTime $exFactoryDate;

    #[Column(name: "sailing_date", type: "date", nullable: true)]
    private ?DateTime $sailingDate;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "delivery_terms", type: "string", nullable: true)]
    private ?string $deliveryTerms;

    #[Column(name: "po_date", type: "datetime", nullable: true)]
    private ?DateTime $poDate;

    #[Column(name: "cart_lines", type: "string", nullable: true)]
    private ?string $cartLines;

    #[Column(name: "pl_lines", type: "string", nullable: true)]
    private ?string $plLines;

    #[Column(type: "integer")]
    private int $freezed;

    #[Column(name: "pl_pdf", type: "string", nullable: true)]
    private ?string $plPdf;

    #[Column(name: "in_pdf", type: "string", nullable: true)]
    private ?string $inPdf;

    #[Column(name: "a_operator", type: "smallint", nullable: true)]
    private ?int $aOperator;

    #[Column(name: "port_delivery", type: "string", nullable: true)]
    private ?string $portDelivery;

    #[Column(name: "dispatch_details", type: "string", nullable: true)]
    private ?string $dispatchDetails;

    public function __construct()
    {
        $this->operator = 0;
        $this->cartLines = '30,40';
        $this->plLines = '30,50';
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getBarcode(): ?string
    {
        return HtmlDecode($this->barcode);
    }

    public function setBarcode(?string $value): static
    {
        $this->barcode = RemoveXss($value);
        return $this;
    }

    public function getExporter(): ?string
    {
        return HtmlDecode($this->exporter);
    }

    public function setExporter(?string $value): static
    {
        $this->exporter = RemoveXss($value);
        return $this;
    }

    public function getConsignee(): ?string
    {
        return HtmlDecode($this->consignee);
    }

    public function setConsignee(?string $value): static
    {
        $this->consignee = RemoveXss($value);
        return $this;
    }

    public function getConsigneeOther(): ?string
    {
        return HtmlDecode($this->consigneeOther);
    }

    public function setConsigneeOther(?string $value): static
    {
        $this->consigneeOther = RemoveXss($value);
        return $this;
    }

    public function getPackingListNo(): ?string
    {
        return $this->packingListNo;
    }

    public function setPackingListNo(?string $value): static
    {
        $this->packingListNo = $value;
        return $this;
    }

    public function getD11(): ?string
    {
        return HtmlDecode($this->d11);
    }

    public function setD11(?string $value): static
    {
        $this->d11 = RemoveXss($value);
        return $this;
    }

    public function getDescription11(): ?string
    {
        return HtmlDecode($this->description11);
    }

    public function setDescription11(?string $value): static
    {
        $this->description11 = RemoveXss($value);
        return $this;
    }

    public function getInTemplate(): ?string
    {
        return HtmlDecode($this->inTemplate);
    }

    public function setInTemplate(?string $value): static
    {
        $this->inTemplate = RemoveXss($value);
        return $this;
    }

    public function getPlTemplate(): ?string
    {
        return HtmlDecode($this->plTemplate);
    }

    public function setPlTemplate(?string $value): static
    {
        $this->plTemplate = RemoveXss($value);
        return $this;
    }

    public function getInvoiceNo(): ?string
    {
        return HtmlDecode($this->invoiceNo);
    }

    public function setInvoiceNo(?string $value): static
    {
        $this->invoiceNo = RemoveXss($value);
        return $this;
    }

    public function getInvoiceDate(): ?DateTime
    {
        return $this->invoiceDate;
    }

    public function setInvoiceDate(?DateTime $value): static
    {
        $this->invoiceDate = $value;
        return $this;
    }

    public function getPoNo(): ?string
    {
        return HtmlDecode($this->poNo);
    }

    public function setPoNo(?string $value): static
    {
        $this->poNo = RemoveXss($value);
        return $this;
    }

    public function getOtherReference(): ?string
    {
        return HtmlDecode($this->otherReference);
    }

    public function setOtherReference(?string $value): static
    {
        $this->otherReference = RemoveXss($value);
        return $this;
    }

    public function getOrigin(): ?string
    {
        return HtmlDecode($this->origin);
    }

    public function setOrigin(?string $value): static
    {
        $this->origin = RemoveXss($value);
        return $this;
    }

    public function getFinalDestination(): ?string
    {
        return HtmlDecode($this->finalDestination);
    }

    public function setFinalDestination(?string $value): static
    {
        $this->finalDestination = RemoveXss($value);
        return $this;
    }

    public function getPaymentTerms(): ?string
    {
        return HtmlDecode($this->paymentTerms);
    }

    public function setPaymentTerms(?string $value): static
    {
        $this->paymentTerms = RemoveXss($value);
        return $this;
    }

    public function getPreCarriageReceipt(): ?string
    {
        return HtmlDecode($this->preCarriageReceipt);
    }

    public function setPreCarriageReceipt(?string $value): static
    {
        $this->preCarriageReceipt = RemoveXss($value);
        return $this;
    }

    public function getPlaceOfReceipt(): ?string
    {
        return HtmlDecode($this->placeOfReceipt);
    }

    public function setPlaceOfReceipt(?string $value): static
    {
        $this->placeOfReceipt = RemoveXss($value);
        return $this;
    }

    public function getLoadingPort(): ?string
    {
        return HtmlDecode($this->loadingPort);
    }

    public function setLoadingPort(?string $value): static
    {
        $this->loadingPort = RemoveXss($value);
        return $this;
    }

    public function getPortDischarge(): ?string
    {
        return HtmlDecode($this->portDischarge);
    }

    public function setPortDischarge(?string $value): static
    {
        $this->portDischarge = RemoveXss($value);
        return $this;
    }

    public function getD01(): ?string
    {
        return HtmlDecode($this->d01);
    }

    public function setD01(?string $value): static
    {
        $this->d01 = RemoveXss($value);
        return $this;
    }

    public function getDescription01(): ?string
    {
        return HtmlDecode($this->description01);
    }

    public function setDescription01(?string $value): static
    {
        $this->description01 = RemoveXss($value);
        return $this;
    }

    public function getD02(): ?string
    {
        return HtmlDecode($this->d02);
    }

    public function setD02(?string $value): static
    {
        $this->d02 = RemoveXss($value);
        return $this;
    }

    public function getDescription02(): ?string
    {
        return HtmlDecode($this->description02);
    }

    public function setDescription02(?string $value): static
    {
        $this->description02 = RemoveXss($value);
        return $this;
    }

    public function getGrossWeight(): ?string
    {
        return HtmlDecode($this->grossWeight);
    }

    public function setGrossWeight(?string $value): static
    {
        $this->grossWeight = RemoveXss($value);
        return $this;
    }

    public function getNettWeight(): ?string
    {
        return HtmlDecode($this->nettWeight);
    }

    public function setNettWeight(?string $value): static
    {
        $this->nettWeight = RemoveXss($value);
        return $this;
    }

    public function getCbm(): ?string
    {
        return HtmlDecode($this->cbm);
    }

    public function setCbm(?string $value): static
    {
        $this->cbm = RemoveXss($value);
        return $this;
    }

    public function getExporterBankDetails(): ?string
    {
        return HtmlDecode($this->exporterBankDetails);
    }

    public function setExporterBankDetails(?string $value): static
    {
        $this->exporterBankDetails = RemoveXss($value);
        return $this;
    }

    public function getIntermediaryBank(): ?string
    {
        return HtmlDecode($this->intermediaryBank);
    }

    public function setIntermediaryBank(?string $value): static
    {
        $this->intermediaryBank = RemoveXss($value);
        return $this;
    }

    public function getShipmentMode(): ?int
    {
        return $this->shipmentMode;
    }

    public function setShipmentMode(?int $value): static
    {
        $this->shipmentMode = $value;
        return $this;
    }

    public function getExFactoryDate(): ?DateTime
    {
        return $this->exFactoryDate;
    }

    public function setExFactoryDate(?DateTime $value): static
    {
        $this->exFactoryDate = $value;
        return $this;
    }

    public function getSailingDate(): ?DateTime
    {
        return $this->sailingDate;
    }

    public function setSailingDate(?DateTime $value): static
    {
        $this->sailingDate = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getDeliveryTerms(): ?string
    {
        return HtmlDecode($this->deliveryTerms);
    }

    public function setDeliveryTerms(?string $value): static
    {
        $this->deliveryTerms = RemoveXss($value);
        return $this;
    }

    public function getPoDate(): ?DateTime
    {
        return $this->poDate;
    }

    public function setPoDate(?DateTime $value): static
    {
        $this->poDate = $value;
        return $this;
    }

    public function getCartLines(): ?string
    {
        return HtmlDecode($this->cartLines);
    }

    public function setCartLines(?string $value): static
    {
        $this->cartLines = RemoveXss($value);
        return $this;
    }

    public function getPlLines(): ?string
    {
        return HtmlDecode($this->plLines);
    }

    public function setPlLines(?string $value): static
    {
        $this->plLines = RemoveXss($value);
        return $this;
    }

    public function getFreezed(): int
    {
        return $this->freezed;
    }

    public function setFreezed(int $value): static
    {
        $this->freezed = $value;
        return $this;
    }

    public function getPlPdf(): ?string
    {
        return HtmlDecode($this->plPdf);
    }

    public function setPlPdf(?string $value): static
    {
        $this->plPdf = RemoveXss($value);
        return $this;
    }

    public function getInPdf(): ?string
    {
        return HtmlDecode($this->inPdf);
    }

    public function setInPdf(?string $value): static
    {
        $this->inPdf = RemoveXss($value);
        return $this;
    }

    public function getAOperator(): ?int
    {
        return $this->aOperator;
    }

    public function setAOperator(?int $value): static
    {
        $this->aOperator = $value;
        return $this;
    }

    public function getPortDelivery(): ?string
    {
        return HtmlDecode($this->portDelivery);
    }

    public function setPortDelivery(?string $value): static
    {
        $this->portDelivery = RemoveXss($value);
        return $this;
    }

    public function getDispatchDetails(): ?string
    {
        return HtmlDecode($this->dispatchDetails);
    }

    public function setDispatchDetails(?string $value): static
    {
        $this->dispatchDetails = RemoveXss($value);
        return $this;
    }
}
