<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "investor_list" table
 */
#[Entity]
#[Table(name: "investor_list")]
class InvestorList extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "share_no", type: "integer")]
    private int $shareNo;

    #[Column(name: "folio_no", type: "smallint")]
    private int $folioNo;

    #[Column(type: "smallint")]
    private int $qty;

    #[Column(name: "transfer_id_old", type: "integer")]
    private int $transferIdOld;

    #[Column(name: "transfer_id_new", type: "integer")]
    private int $transferIdNew;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->qty = 1;
        $this->transferIdOld = 0;
        $this->transferIdNew = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getShareNo(): int
    {
        return $this->shareNo;
    }

    public function setShareNo(int $value): static
    {
        $this->shareNo = $value;
        return $this;
    }

    public function getFolioNo(): int
    {
        return $this->folioNo;
    }

    public function setFolioNo(int $value): static
    {
        $this->folioNo = $value;
        return $this;
    }

    public function getQty(): int
    {
        return $this->qty;
    }

    public function setQty(int $value): static
    {
        $this->qty = $value;
        return $this;
    }

    public function getTransferIdOld(): int
    {
        return $this->transferIdOld;
    }

    public function setTransferIdOld(int $value): static
    {
        $this->transferIdOld = $value;
        return $this;
    }

    public function getTransferIdNew(): int
    {
        return $this->transferIdNew;
    }

    public function setTransferIdNew(int $value): static
    {
        $this->transferIdNew = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
