<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "investor_info" table
 */
#[Entity]
#[Table(name: "investor_info")]
class InvestorInfo extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "integer", nullable: true)]
    private ?int $qty;

    #[Column(name: "aadhaar_no", type: "string", nullable: true)]
    private ?string $aadhaarNo;

    #[Column(type: "string", nullable: true)]
    private ?string $name;

    #[Column(type: "string", nullable: true)]
    private ?string $gender;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dob;

    #[Column(type: "string", nullable: true)]
    private ?string $mobile;

    #[Column(type: "string", nullable: true)]
    private ?string $email;

    #[Column(type: "string", nullable: true)]
    private ?string $address;

    #[Column(name: "care_of", type: "string", nullable: true)]
    private ?string $careOf;

    #[Column(name: "father_name", type: "string", nullable: true)]
    private ?string $fatherName;

    #[Column(name: "mother_name", type: "string", nullable: true)]
    private ?string $motherName;

    #[Column(name: "nominee_name", type: "string", nullable: true)]
    private ?string $nomineeName;

    #[Column(name: "nominee_relation", type: "string", nullable: true)]
    private ?string $nomineeRelation;

    #[Column(name: "pan_no", type: "string", nullable: true)]
    private ?string $panNo;

    #[Column(type: "string", nullable: true)]
    private ?string $uploads;

    #[Column(type: "text", nullable: true)]
    private ?string $image;

    #[Column(type: "smallint", nullable: true)]
    private ?int $adviser;

    #[Column(name: "share_no", type: "text", nullable: true)]
    private ?string $shareNo;

    #[Column(name: "inv_start_date", type: "date", nullable: true)]
    private ?DateTime $invStartDate;

    #[Column(type: "decimal", nullable: true)]
    private ?string $amount;

    #[Column(type: "decimal", nullable: true)]
    private ?string $gurantee;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "integer", nullable: true)]
    private ?int $otp;

    #[Column(name: "pan_response", type: "string", nullable: true)]
    private ?string $panResponse;

    #[Column(name: "pan_verify_datetime", type: "datetime", nullable: true)]
    private ?DateTime $panVerifyDatetime;

    #[Column(name: "aadhaar_response", type: "text", nullable: true)]
    private ?string $aadhaarResponse;

    #[Column(name: "aadhaar_verify_datetime", type: "datetime", nullable: true)]
    private ?DateTime $aadhaarVerifyDatetime;

    #[Column(name: "thumb_data", type: "text", nullable: true)]
    private ?string $thumbData;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getQty(): ?int
    {
        return $this->qty;
    }

    public function setQty(?int $value): static
    {
        $this->qty = $value;
        return $this;
    }

    public function getAadhaarNo(): ?string
    {
        return HtmlDecode($this->aadhaarNo);
    }

    public function setAadhaarNo(?string $value): static
    {
        $this->aadhaarNo = RemoveXss($value);
        return $this;
    }

    public function getName(): ?string
    {
        return HtmlDecode($this->name);
    }

    public function setName(?string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getGender(): ?string
    {
        return HtmlDecode($this->gender);
    }

    public function setGender(?string $value): static
    {
        $this->gender = RemoveXss($value);
        return $this;
    }

    public function getDob(): ?DateTime
    {
        return $this->dob;
    }

    public function setDob(?DateTime $value): static
    {
        $this->dob = $value;
        return $this;
    }

    public function getMobile(): ?string
    {
        return HtmlDecode($this->mobile);
    }

    public function setMobile(?string $value): static
    {
        $this->mobile = RemoveXss($value);
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getAddress(): ?string
    {
        return HtmlDecode($this->address);
    }

    public function setAddress(?string $value): static
    {
        $this->address = RemoveXss($value);
        return $this;
    }

    public function getCareOf(): ?string
    {
        return HtmlDecode($this->careOf);
    }

    public function setCareOf(?string $value): static
    {
        $this->careOf = RemoveXss($value);
        return $this;
    }

    public function getFatherName(): ?string
    {
        return HtmlDecode($this->fatherName);
    }

    public function setFatherName(?string $value): static
    {
        $this->fatherName = RemoveXss($value);
        return $this;
    }

    public function getMotherName(): ?string
    {
        return HtmlDecode($this->motherName);
    }

    public function setMotherName(?string $value): static
    {
        $this->motherName = RemoveXss($value);
        return $this;
    }

    public function getNomineeName(): ?string
    {
        return HtmlDecode($this->nomineeName);
    }

    public function setNomineeName(?string $value): static
    {
        $this->nomineeName = RemoveXss($value);
        return $this;
    }

    public function getNomineeRelation(): ?string
    {
        return HtmlDecode($this->nomineeRelation);
    }

    public function setNomineeRelation(?string $value): static
    {
        $this->nomineeRelation = RemoveXss($value);
        return $this;
    }

    public function getPanNo(): ?string
    {
        return HtmlDecode($this->panNo);
    }

    public function setPanNo(?string $value): static
    {
        $this->panNo = RemoveXss($value);
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getImage(): ?string
    {
        return HtmlDecode($this->image);
    }

    public function setImage(?string $value): static
    {
        $this->image = RemoveXss($value);
        return $this;
    }

    public function getAdviser(): ?int
    {
        return $this->adviser;
    }

    public function setAdviser(?int $value): static
    {
        $this->adviser = $value;
        return $this;
    }

    public function getShareNo(): ?string
    {
        return HtmlDecode($this->shareNo);
    }

    public function setShareNo(?string $value): static
    {
        $this->shareNo = RemoveXss($value);
        return $this;
    }

    public function getInvStartDate(): ?DateTime
    {
        return $this->invStartDate;
    }

    public function setInvStartDate(?DateTime $value): static
    {
        $this->invStartDate = $value;
        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getGurantee(): ?string
    {
        return $this->gurantee;
    }

    public function setGurantee(?string $value): static
    {
        $this->gurantee = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getOtp(): ?int
    {
        return $this->otp;
    }

    public function setOtp(?int $value): static
    {
        $this->otp = $value;
        return $this;
    }

    public function getPanResponse(): ?string
    {
        return HtmlDecode($this->panResponse);
    }

    public function setPanResponse(?string $value): static
    {
        $this->panResponse = RemoveXss($value);
        return $this;
    }

    public function getPanVerifyDatetime(): ?DateTime
    {
        return $this->panVerifyDatetime;
    }

    public function setPanVerifyDatetime(?DateTime $value): static
    {
        $this->panVerifyDatetime = $value;
        return $this;
    }

    public function getAadhaarResponse(): ?string
    {
        return HtmlDecode($this->aadhaarResponse);
    }

    public function setAadhaarResponse(?string $value): static
    {
        $this->aadhaarResponse = RemoveXss($value);
        return $this;
    }

    public function getAadhaarVerifyDatetime(): ?DateTime
    {
        return $this->aadhaarVerifyDatetime;
    }

    public function setAadhaarVerifyDatetime(?DateTime $value): static
    {
        $this->aadhaarVerifyDatetime = $value;
        return $this;
    }

    public function getThumbData(): ?string
    {
        return HtmlDecode($this->thumbData);
    }

    public function setThumbData(?string $value): static
    {
        $this->thumbData = RemoveXss($value);
        return $this;
    }
}
