<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "int_shop" table
 */
#[Entity]
#[Table(name: "int_shop")]
class IntShop extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $category;

    #[Column(name: "short_description", type: "string", nullable: true)]
    private ?string $shortDescription;

    #[Column(type: "string", nullable: true)]
    private ?string $includes;

    #[Column(type: "text", nullable: true)]
    private ?string $description;

    #[Column(type: "decimal", nullable: true)]
    private ?string $price;

    #[Column(name: "discount_coupon", type: "string", nullable: true)]
    private ?string $discountCoupon;

    #[Column(type: "decimal")]
    private string $discount;

    #[Column(type: "decimal", nullable: true)]
    private ?string $amount;

    #[Column(name: "valid_till", type: "date", nullable: true)]
    private ?DateTime $validTill;

    #[Column(type: "smallint", nullable: true)]
    private ?int $status;

    #[Column(type: "string", nullable: true)]
    private ?string $response;

    #[Column(type: "text", nullable: true)]
    private ?string $code;

    #[Column(name: "show_to", type: "string", nullable: true)]
    private ?string $showTo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->showTo = "0";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getCategory(): ?string
    {
        return HtmlDecode($this->category);
    }

    public function setCategory(?string $value): static
    {
        $this->category = RemoveXss($value);
        return $this;
    }

    public function getShortDescription(): ?string
    {
        return HtmlDecode($this->shortDescription);
    }

    public function setShortDescription(?string $value): static
    {
        $this->shortDescription = RemoveXss($value);
        return $this;
    }

    public function getIncludes(): ?string
    {
        return HtmlDecode($this->includes);
    }

    public function setIncludes(?string $value): static
    {
        $this->includes = RemoveXss($value);
        return $this;
    }

    public function getDescription(): ?string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(?string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getPrice(): ?string
    {
        return $this->price;
    }

    public function setPrice(?string $value): static
    {
        $this->price = $value;
        return $this;
    }

    public function getDiscountCoupon(): ?string
    {
        return HtmlDecode($this->discountCoupon);
    }

    public function setDiscountCoupon(?string $value): static
    {
        $this->discountCoupon = RemoveXss($value);
        return $this;
    }

    public function getDiscount(): string
    {
        return $this->discount;
    }

    public function setDiscount(string $value): static
    {
        $this->discount = $value;
        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getValidTill(): ?DateTime
    {
        return $this->validTill;
    }

    public function setValidTill(?DateTime $value): static
    {
        $this->validTill = $value;
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getResponse(): ?string
    {
        return HtmlDecode($this->response);
    }

    public function setResponse(?string $value): static
    {
        $this->response = RemoveXss($value);
        return $this;
    }

    public function getCode(): ?string
    {
        return HtmlDecode($this->code);
    }

    public function setCode(?string $value): static
    {
        $this->code = RemoveXss($value);
        return $this;
    }

    public function getShowTo(): ?string
    {
        return HtmlDecode($this->showTo);
    }

    public function setShowTo(?string $value): static
    {
        $this->showTo = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
