<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "int_fibre_help" table
 */
#[Entity]
#[Table(name: "int_fibre_help")]
class IntFibreHelp extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $level;

    #[Column(name: "field_name", type: "string", nullable: true)]
    private ?string $fieldName;

    #[Column(name: "field_caption", type: "string", nullable: true)]
    private ?string $fieldCaption;

    #[Column(name: "field_description", type: "string", nullable: true)]
    private ?string $fieldDescription;

    #[Column(name: "table_name", type: "string", nullable: true)]
    private ?string $tableName;

    #[Column(name: "table_caption", type: "string", nullable: true)]
    private ?string $tableCaption;

    #[Column(name: "table_description", type: "text", nullable: true)]
    private ?string $tableDescription;

    #[Column(name: "menu_group", type: "string", nullable: true)]
    private ?string $menuGroup;

    #[Column(name: "menu_description", type: "text", nullable: true)]
    private ?string $menuDescription;

    #[Column(name: "system_notes", type: "text", nullable: true)]
    private ?string $systemNotes;

    #[Column(name: "portal_notes", type: "text", nullable: true)]
    private ?string $portalNotes;

    #[Column(name: "admin_notes", type: "text", nullable: true)]
    private ?string $adminNotes;

    #[Column(type: "integer")]
    private int $visible;

    #[Column(type: "smallint")]
    private int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->level = 0;
        $this->visible = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLevel(): int
    {
        return $this->level;
    }

    public function setLevel(int $value): static
    {
        $this->level = $value;
        return $this;
    }

    public function getFieldName(): ?string
    {
        return HtmlDecode($this->fieldName);
    }

    public function setFieldName(?string $value): static
    {
        $this->fieldName = RemoveXss($value);
        return $this;
    }

    public function getFieldCaption(): ?string
    {
        return HtmlDecode($this->fieldCaption);
    }

    public function setFieldCaption(?string $value): static
    {
        $this->fieldCaption = RemoveXss($value);
        return $this;
    }

    public function getFieldDescription(): ?string
    {
        return HtmlDecode($this->fieldDescription);
    }

    public function setFieldDescription(?string $value): static
    {
        $this->fieldDescription = RemoveXss($value);
        return $this;
    }

    public function getTableName(): ?string
    {
        return HtmlDecode($this->tableName);
    }

    public function setTableName(?string $value): static
    {
        $this->tableName = RemoveXss($value);
        return $this;
    }

    public function getTableCaption(): ?string
    {
        return HtmlDecode($this->tableCaption);
    }

    public function setTableCaption(?string $value): static
    {
        $this->tableCaption = RemoveXss($value);
        return $this;
    }

    public function getTableDescription(): ?string
    {
        return HtmlDecode($this->tableDescription);
    }

    public function setTableDescription(?string $value): static
    {
        $this->tableDescription = RemoveXss($value);
        return $this;
    }

    public function getMenuGroup(): ?string
    {
        return HtmlDecode($this->menuGroup);
    }

    public function setMenuGroup(?string $value): static
    {
        $this->menuGroup = RemoveXss($value);
        return $this;
    }

    public function getMenuDescription(): ?string
    {
        return HtmlDecode($this->menuDescription);
    }

    public function setMenuDescription(?string $value): static
    {
        $this->menuDescription = RemoveXss($value);
        return $this;
    }

    public function getSystemNotes(): ?string
    {
        return HtmlDecode($this->systemNotes);
    }

    public function setSystemNotes(?string $value): static
    {
        $this->systemNotes = RemoveXss($value);
        return $this;
    }

    public function getPortalNotes(): ?string
    {
        return HtmlDecode($this->portalNotes);
    }

    public function setPortalNotes(?string $value): static
    {
        $this->portalNotes = RemoveXss($value);
        return $this;
    }

    public function getAdminNotes(): ?string
    {
        return HtmlDecode($this->adminNotes);
    }

    public function setAdminNotes(?string $value): static
    {
        $this->adminNotes = RemoveXss($value);
        return $this;
    }

    public function getVisible(): int
    {
        return $this->visible;
    }

    public function setVisible(int $value): static
    {
        $this->visible = $value;
        return $this;
    }

    public function getOperator(): int
    {
        return $this->operator;
    }

    public function setOperator(int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
