<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "godown_transfer_table" table
 */
#[Entity]
#[Table(name: "godown_transfer_table")]
class GodownTransferTable extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(type: "smallint")]
    private int $product;

    #[Column(type: "integer", nullable: true)]
    private ?int $ref;

    #[Column(type: "smallint")]
    private int $rid;

    #[Column(type: "smallint", nullable: true)]
    private ?int $packets;

    #[Column(name: "quantity_avg_act", type: "integer", nullable: true)]
    private ?int $quantityAvgAct;

    #[Column(type: "decimal", nullable: true)]
    private ?string $quantity;

    #[Column(name: "packing_type", type: "integer", nullable: true)]
    private ?int $packingType;

    #[Column(type: "integer", nullable: true)]
    private ?int $godown;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dated;

    #[Column(name: "employee_id", type: "string")]
    private string $employeeId;

    #[Column(name: "next_issue_yn", type: "integer")]
    private int $nextIssueYn;

    #[Column(name: "next_process", type: "smallint", nullable: true)]
    private ?int $nextProcess;

    #[Column(name: "next_godown", type: "smallint", nullable: true)]
    private ?int $nextGodown;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "count_received", type: "string")]
    private string $countReceived;

    #[Column(name: "gp_no", type: "smallint")]
    private int $gpNo;

    #[Column(type: "smallint")]
    private int $po;

    public function __construct()
    {
        $this->quantityAvgAct = 0;
        $this->quantity = "0";
        $this->employeeId = "1001";
        $this->nextIssueYn = 0;
        $this->operator = 0;
        $this->gpNo = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getProduct(): int
    {
        return $this->product;
    }

    public function setProduct(int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRef(): ?int
    {
        return $this->ref;
    }

    public function setRef(?int $value): static
    {
        $this->ref = $value;
        return $this;
    }

    public function getRid(): int
    {
        return $this->rid;
    }

    public function setRid(int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getPackets(): ?int
    {
        return $this->packets;
    }

    public function setPackets(?int $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getQuantityAvgAct(): ?int
    {
        return $this->quantityAvgAct;
    }

    public function setQuantityAvgAct(?int $value): static
    {
        $this->quantityAvgAct = $value;
        return $this;
    }

    public function getQuantity(): ?string
    {
        return $this->quantity;
    }

    public function setQuantity(?string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getGodown(): ?int
    {
        return $this->godown;
    }

    public function setGodown(?int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getDated(): ?DateTime
    {
        return $this->dated;
    }

    public function setDated(?DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getEmployeeId(): string
    {
        return HtmlDecode($this->employeeId);
    }

    public function setEmployeeId(string $value): static
    {
        $this->employeeId = RemoveXss($value);
        return $this;
    }

    public function getNextIssueYn(): int
    {
        return $this->nextIssueYn;
    }

    public function setNextIssueYn(int $value): static
    {
        $this->nextIssueYn = $value;
        return $this;
    }

    public function getNextProcess(): ?int
    {
        return $this->nextProcess;
    }

    public function setNextProcess(?int $value): static
    {
        $this->nextProcess = $value;
        return $this;
    }

    public function getNextGodown(): ?int
    {
        return $this->nextGodown;
    }

    public function setNextGodown(?int $value): static
    {
        $this->nextGodown = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getCountReceived(): string
    {
        return HtmlDecode($this->countReceived);
    }

    public function setCountReceived(string $value): static
    {
        $this->countReceived = RemoveXss($value);
        return $this;
    }

    public function getGpNo(): int
    {
        return $this->gpNo;
    }

    public function setGpNo(int $value): static
    {
        $this->gpNo = $value;
        return $this;
    }

    public function getPo(): int
    {
        return $this->po;
    }

    public function setPo(int $value): static
    {
        $this->po = $value;
        return $this;
    }
}
