<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "godown_transfer_hs" table
 */
#[Entity]
#[Table(name: "godown_transfer_hs")]
class GodownTransferH extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $product;

    #[Column(type: "integer", nullable: true)]
    private ?int $ref;

    #[Column(type: "smallint", nullable: true)]
    private ?int $packets;

    #[Column(type: "decimal", nullable: true)]
    private ?string $quantity;

    #[Column(name: "packing_type", type: "integer", nullable: true)]
    private ?int $packingType;

    #[Column(type: "integer", nullable: true)]
    private ?int $godown;

    #[Column(name: "issue_to", type: "integer")]
    private int $issueTo;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dated;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "quantity_avg_act", type: "integer", nullable: true)]
    private ?int $quantityAvgAct;

    #[Column(type: "smallint")]
    private int $rid;

    public function __construct()
    {
        $this->operator = 0;
        $this->quantityAvgAct = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getProduct(): int
    {
        return $this->product;
    }

    public function setProduct(int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRef(): ?int
    {
        return $this->ref;
    }

    public function setRef(?int $value): static
    {
        $this->ref = $value;
        return $this;
    }

    public function getPackets(): ?int
    {
        return $this->packets;
    }

    public function setPackets(?int $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getQuantity(): ?string
    {
        return $this->quantity;
    }

    public function setQuantity(?string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getGodown(): ?int
    {
        return $this->godown;
    }

    public function setGodown(?int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getIssueTo(): int
    {
        return $this->issueTo;
    }

    public function setIssueTo(int $value): static
    {
        $this->issueTo = $value;
        return $this;
    }

    public function getDated(): ?DateTime
    {
        return $this->dated;
    }

    public function setDated(?DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getQuantityAvgAct(): ?int
    {
        return $this->quantityAvgAct;
    }

    public function setQuantityAvgAct(?int $value): static
    {
        $this->quantityAvgAct = $value;
        return $this;
    }

    public function getRid(): int
    {
        return $this->rid;
    }

    public function setRid(int $value): static
    {
        $this->rid = $value;
        return $this;
    }
}
