<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "gate_pass_received" table
 */
#[Entity]
#[Table(name: "gate_pass_received")]
class GatePassReceived extends AbstractEntity
{
    #[Id]
    #[Column(name: "gp_no", type: "smallint")]
    #[GeneratedValue]
    private int $gpNo;

    #[Column(type: "string")]
    private string $print;

    #[Column(name: "`from`", options: ["name" => "from"], type: "integer")]
    private int $from;

    #[Column(name: "`to`", options: ["name" => "to"], type: "integer")]
    private int $to;

    #[Column(type: "smallint")]
    private int $attention;

    #[Column(name: "transfer_nature", type: "smallint")]
    private int $transferNature;

    #[Column(name: "due_date", type: "date", nullable: true)]
    private ?DateTime $dueDate;

    #[Column(name: "`group`", options: ["name" => "group"], type: "smallint")]
    private int $group;

    #[Column(type: "smallint")]
    private int $product;

    #[Column(name: "count_received", type: "string")]
    private string $countReceived;

    #[Column(type: "text")]
    private string $item;

    #[Column(name: "gt_id", type: "string")]
    private string $gtId;

    #[Column(type: "decimal", nullable: true)]
    private ?string $quantity;

    #[Column(name: "`despatch details`", options: ["name" => "despatch details"], type: "string")]
    private string $despatchdetails;

    #[Column(name: "sender_comments", type: "string")]
    private string $senderComments;

    #[Column(name: "t_mode", type: "integer", nullable: true)]
    private ?int $tMode;

    #[Column(name: "t_distance", type: "smallint", nullable: true)]
    private ?int $tDistance;

    #[Column(name: "t_v_no", type: "string", nullable: true)]
    private ?string $tVNo;

    #[Column(type: "string", nullable: true)]
    private ?string $purpose;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "e_operator", type: "smallint")]
    private int $eOperator;

    #[Column(name: "e_datetime", type: "datetime")]
    private DateTime $eDatetime;

    #[Column(name: "receiving_condition", type: "smallint")]
    private int $receivingCondition;

    #[Column(name: "receiver_comments", type: "string", nullable: true)]
    private ?string $receiverComments;

    #[Column(name: "r_operator", type: "smallint")]
    private int $rOperator;

    #[Column(name: "r_datetime", type: "datetime")]
    private DateTime $rDatetime;

    #[Column(type: "integer")]
    private int $updated;

    #[Column(name: "r_e_user_id", type: "smallint")]
    private int $rEUserId;

    #[Column(name: "r_e_datetime", type: "datetime")]
    private DateTime $rEDatetime;

    #[Column(name: "jc_no", type: "smallint", nullable: true)]
    private ?int $jcNo;

    public function __construct()
    {
        $this->print = "Print";
        $this->from = (isset($_COOKIE["User_Site"]))? $_COOKIE["User_Site"]:"";
        $this->operator = 0;
        $this->updated = 0;
    }

    public function getGpNo(): int
    {
        return $this->gpNo;
    }

    public function setGpNo(int $value): static
    {
        $this->gpNo = $value;
        return $this;
    }

    public function getPrint(): string
    {
        return HtmlDecode($this->print);
    }

    public function setPrint(string $value): static
    {
        $this->print = RemoveXss($value);
        return $this;
    }

    public function getFrom(): int
    {
        return $this->from;
    }

    public function setFrom(int $value): static
    {
        $this->from = $value;
        return $this;
    }

    public function getTo(): int
    {
        return $this->to;
    }

    public function setTo(int $value): static
    {
        $this->to = $value;
        return $this;
    }

    public function getAttention(): int
    {
        return $this->attention;
    }

    public function setAttention(int $value): static
    {
        $this->attention = $value;
        return $this;
    }

    public function getTransferNature(): int
    {
        return $this->transferNature;
    }

    public function setTransferNature(int $value): static
    {
        $this->transferNature = $value;
        return $this;
    }

    public function getDueDate(): ?DateTime
    {
        return $this->dueDate;
    }

    public function setDueDate(?DateTime $value): static
    {
        $this->dueDate = $value;
        return $this;
    }

    public function getGroup(): int
    {
        return $this->group;
    }

    public function setGroup(int $value): static
    {
        $this->group = $value;
        return $this;
    }

    public function getProduct(): int
    {
        return $this->product;
    }

    public function setProduct(int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getCountReceived(): string
    {
        return HtmlDecode($this->countReceived);
    }

    public function setCountReceived(string $value): static
    {
        $this->countReceived = RemoveXss($value);
        return $this;
    }

    public function getItem(): string
    {
        return HtmlDecode($this->item);
    }

    public function setItem(string $value): static
    {
        $this->item = RemoveXss($value);
        return $this;
    }

    public function getGtId(): string
    {
        return HtmlDecode($this->gtId);
    }

    public function setGtId(string $value): static
    {
        $this->gtId = RemoveXss($value);
        return $this;
    }

    public function getQuantity(): ?string
    {
        return $this->quantity;
    }

    public function setQuantity(?string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getDespatchdetails(): string
    {
        return HtmlDecode($this->despatchdetails);
    }

    public function setDespatchdetails(string $value): static
    {
        $this->despatchdetails = RemoveXss($value);
        return $this;
    }

    public function getSenderComments(): string
    {
        return HtmlDecode($this->senderComments);
    }

    public function setSenderComments(string $value): static
    {
        $this->senderComments = RemoveXss($value);
        return $this;
    }

    public function getTMode(): ?int
    {
        return $this->tMode;
    }

    public function setTMode(?int $value): static
    {
        $this->tMode = $value;
        return $this;
    }

    public function getTDistance(): ?int
    {
        return $this->tDistance;
    }

    public function setTDistance(?int $value): static
    {
        $this->tDistance = $value;
        return $this;
    }

    public function getTVNo(): ?string
    {
        return HtmlDecode($this->tVNo);
    }

    public function setTVNo(?string $value): static
    {
        $this->tVNo = RemoveXss($value);
        return $this;
    }

    public function getPurpose(): ?string
    {
        return HtmlDecode($this->purpose);
    }

    public function setPurpose(?string $value): static
    {
        $this->purpose = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getEOperator(): int
    {
        return $this->eOperator;
    }

    public function setEOperator(int $value): static
    {
        $this->eOperator = $value;
        return $this;
    }

    public function getEDatetime(): DateTime
    {
        return $this->eDatetime;
    }

    public function setEDatetime(DateTime $value): static
    {
        $this->eDatetime = $value;
        return $this;
    }

    public function getReceivingCondition(): int
    {
        return $this->receivingCondition;
    }

    public function setReceivingCondition(int $value): static
    {
        $this->receivingCondition = $value;
        return $this;
    }

    public function getReceiverComments(): ?string
    {
        return HtmlDecode($this->receiverComments);
    }

    public function setReceiverComments(?string $value): static
    {
        $this->receiverComments = RemoveXss($value);
        return $this;
    }

    public function getROperator(): int
    {
        return $this->rOperator;
    }

    public function setROperator(int $value): static
    {
        $this->rOperator = $value;
        return $this;
    }

    public function getRDatetime(): DateTime
    {
        return $this->rDatetime;
    }

    public function setRDatetime(DateTime $value): static
    {
        $this->rDatetime = $value;
        return $this;
    }

    public function getUpdated(): int
    {
        return $this->updated;
    }

    public function setUpdated(int $value): static
    {
        $this->updated = $value;
        return $this;
    }

    public function getREUserId(): int
    {
        return $this->rEUserId;
    }

    public function setREUserId(int $value): static
    {
        $this->rEUserId = $value;
        return $this;
    }

    public function getREDatetime(): DateTime
    {
        return $this->rEDatetime;
    }

    public function setREDatetime(DateTime $value): static
    {
        $this->rEDatetime = $value;
        return $this;
    }

    public function getJcNo(): ?int
    {
        return $this->jcNo;
    }

    public function setJcNo(?int $value): static
    {
        $this->jcNo = $value;
        return $this;
    }
}
