<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "fe_setup" table
 */
#[Entity]
#[Table(name: "fe_setup")]
class FeSetup extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    private int $id;

    #[Column(name: "product_image", type: "smallint")]
    private int $productImage;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "product_group", type: "integer")]
    private int $productGroup;

    #[Column(name: "product_category", type: "integer")]
    private int $productCategory;

    public function __construct()
    {
        $this->operator = 0;
        $this->productGroup = 1;
        $this->productCategory = 1;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getProductImage(): int
    {
        return $this->productImage;
    }

    public function setProductImage(int $value): static
    {
        $this->productImage = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getProductGroup(): int
    {
        return $this->productGroup;
    }

    public function setProductGroup(int $value): static
    {
        $this->productGroup = $value;
        return $this;
    }

    public function getProductCategory(): int
    {
        return $this->productCategory;
    }

    public function setProductCategory(int $value): static
    {
        $this->productCategory = $value;
        return $this;
    }
}
