<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "family_info" table
 */
#[Entity]
#[Table(name: "family_info")]
class FamilyInfo extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "family_personal", type: "smallint", nullable: true)]
    private ?int $familyPersonal;

    #[Column(name: "father_name", type: "string", nullable: true)]
    private ?string $fatherName;

    #[Column(name: "family_id", type: "integer", nullable: true)]
    private ?int $familyId;

    #[Column(type: "string", nullable: true)]
    private ?string $lifecycle;

    #[Column(type: "string", nullable: true)]
    private ?string $gender;

    #[Column(type: "string", nullable: true)]
    private ?string $title;

    #[Column(name: "marital_status", type: "string", nullable: true)]
    private ?string $maritalStatus;

    #[Column(type: "string", nullable: true)]
    private ?string $name;

    #[Column(type: "bigint", nullable: true)]
    private ?string $mobile;

    #[Column(name: "spouse_name", type: "string", nullable: true)]
    private ?string $spouseName;

    #[Column(name: "mobile_spouse", type: "string", nullable: true)]
    private ?string $mobileSpouse;

    #[Column(type: "string", nullable: true)]
    private ?string $email;

    #[Column(type: "string", nullable: true)]
    private ?string $category;

    #[Column(type: "string", nullable: true)]
    private ?string $event;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dob;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dom;

    #[Column(type: "string", nullable: true)]
    private ?string $address;

    #[Column(type: "smallint", nullable: true)]
    private ?int $country;

    #[Column(type: "smallint", nullable: true)]
    private ?int $state;

    #[Column(name: "city_india", type: "integer", nullable: true)]
    private ?int $cityIndia;

    #[Column(type: "integer", nullable: true)]
    private ?int $city;

    #[Column(name: "city_name", type: "string", nullable: true)]
    private ?string $cityName;

    #[Column(type: "string", nullable: true)]
    private ?string $image;

    #[Column(name: "work_details", type: "string", nullable: true)]
    private ?string $workDetails;

    #[Column(type: "smallint", nullable: true)]
    private ?int $sequence;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "integer")]
    private int $status;

    #[Column(name: "sort_order", type: "decimal")]
    private string $sortOrder;

    public function __construct()
    {
        $this->familyPersonal = 1;
        $this->lifecycle = 'Live';
        $this->gender = 'Male';
        $this->title = 'Shri';
        $this->category = "1";
        $this->operator = 0;
        $this->status = 1;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getFamilyPersonal(): ?int
    {
        return $this->familyPersonal;
    }

    public function setFamilyPersonal(?int $value): static
    {
        $this->familyPersonal = $value;
        return $this;
    }

    public function getFatherName(): ?string
    {
        return HtmlDecode($this->fatherName);
    }

    public function setFatherName(?string $value): static
    {
        $this->fatherName = RemoveXss($value);
        return $this;
    }

    public function getFamilyId(): ?int
    {
        return $this->familyId;
    }

    public function setFamilyId(?int $value): static
    {
        $this->familyId = $value;
        return $this;
    }

    public function getLifecycle(): ?string
    {
        return HtmlDecode($this->lifecycle);
    }

    public function setLifecycle(?string $value): static
    {
        $this->lifecycle = RemoveXss($value);
        return $this;
    }

    public function getGender(): ?string
    {
        return HtmlDecode($this->gender);
    }

    public function setGender(?string $value): static
    {
        $this->gender = RemoveXss($value);
        return $this;
    }

    public function getTitle(): ?string
    {
        return HtmlDecode($this->title);
    }

    public function setTitle(?string $value): static
    {
        $this->title = RemoveXss($value);
        return $this;
    }

    public function getMaritalStatus(): ?string
    {
        return HtmlDecode($this->maritalStatus);
    }

    public function setMaritalStatus(?string $value): static
    {
        $this->maritalStatus = RemoveXss($value);
        return $this;
    }

    public function getName(): ?string
    {
        return HtmlDecode($this->name);
    }

    public function setName(?string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getMobile(): ?string
    {
        return $this->mobile;
    }

    public function setMobile(?string $value): static
    {
        $this->mobile = $value;
        return $this;
    }

    public function getSpouseName(): ?string
    {
        return HtmlDecode($this->spouseName);
    }

    public function setSpouseName(?string $value): static
    {
        $this->spouseName = RemoveXss($value);
        return $this;
    }

    public function getMobileSpouse(): ?string
    {
        return HtmlDecode($this->mobileSpouse);
    }

    public function setMobileSpouse(?string $value): static
    {
        $this->mobileSpouse = RemoveXss($value);
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getCategory(): ?string
    {
        return HtmlDecode($this->category);
    }

    public function setCategory(?string $value): static
    {
        $this->category = RemoveXss($value);
        return $this;
    }

    public function getEvent(): ?string
    {
        return HtmlDecode($this->event);
    }

    public function setEvent(?string $value): static
    {
        $this->event = RemoveXss($value);
        return $this;
    }

    public function getDob(): ?DateTime
    {
        return $this->dob;
    }

    public function setDob(?DateTime $value): static
    {
        $this->dob = $value;
        return $this;
    }

    public function getDom(): ?DateTime
    {
        return $this->dom;
    }

    public function setDom(?DateTime $value): static
    {
        $this->dom = $value;
        return $this;
    }

    public function getAddress(): ?string
    {
        return HtmlDecode($this->address);
    }

    public function setAddress(?string $value): static
    {
        $this->address = RemoveXss($value);
        return $this;
    }

    public function getCountry(): ?int
    {
        return $this->country;
    }

    public function setCountry(?int $value): static
    {
        $this->country = $value;
        return $this;
    }

    public function getState(): ?int
    {
        return $this->state;
    }

    public function setState(?int $value): static
    {
        $this->state = $value;
        return $this;
    }

    public function getCityIndia(): ?int
    {
        return $this->cityIndia;
    }

    public function setCityIndia(?int $value): static
    {
        $this->cityIndia = $value;
        return $this;
    }

    public function getCity(): ?int
    {
        return $this->city;
    }

    public function setCity(?int $value): static
    {
        $this->city = $value;
        return $this;
    }

    public function getCityName(): ?string
    {
        return HtmlDecode($this->cityName);
    }

    public function setCityName(?string $value): static
    {
        $this->cityName = RemoveXss($value);
        return $this;
    }

    public function getImage(): ?string
    {
        return HtmlDecode($this->image);
    }

    public function setImage(?string $value): static
    {
        $this->image = RemoveXss($value);
        return $this;
    }

    public function getWorkDetails(): ?string
    {
        return HtmlDecode($this->workDetails);
    }

    public function setWorkDetails(?string $value): static
    {
        $this->workDetails = RemoveXss($value);
        return $this;
    }

    public function getSequence(): ?int
    {
        return $this->sequence;
    }

    public function setSequence(?int $value): static
    {
        $this->sequence = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getSortOrder(): string
    {
        return $this->sortOrder;
    }

    public function setSortOrder(string $value): static
    {
        $this->sortOrder = $value;
        return $this;
    }
}
