<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "family_event_list" table
 */
#[Entity]
#[Table(name: "family_event_list")]
class FamilyEventList extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "event_type", type: "smallint", nullable: true)]
    private ?int $eventType;

    #[Column(name: "event_name", type: "string", nullable: true)]
    private ?string $eventName;

    #[Column(name: "sub_event", type: "string", nullable: true)]
    private ?string $subEvent;

    #[Column(type: "string", nullable: true)]
    private ?string $description;

    #[Column(name: "event_id", type: "decimal", unique: true, nullable: true)]
    private ?string $eventId;

    #[Column(name: "start_date", type: "datetime")]
    private DateTime $startDate;

    #[Column(name: "end_date", type: "datetime", nullable: true)]
    private ?DateTime $endDate;

    #[Column(type: "string", nullable: true)]
    private ?string $location;

    #[Column(type: "smallint", nullable: true)]
    private ?int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "text")]
    private string $menu;

    #[Column(type: "text", nullable: true)]
    private ?string $decor;

    public function __construct()
    {
        $this->eventType = 1;
        $this->eventId = "0.00";
        $this->status = 1;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getEventType(): ?int
    {
        return $this->eventType;
    }

    public function setEventType(?int $value): static
    {
        $this->eventType = $value;
        return $this;
    }

    public function getEventName(): ?string
    {
        return HtmlDecode($this->eventName);
    }

    public function setEventName(?string $value): static
    {
        $this->eventName = RemoveXss($value);
        return $this;
    }

    public function getSubEvent(): ?string
    {
        return HtmlDecode($this->subEvent);
    }

    public function setSubEvent(?string $value): static
    {
        $this->subEvent = RemoveXss($value);
        return $this;
    }

    public function getDescription(): ?string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(?string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getEventId(): ?string
    {
        return $this->eventId;
    }

    public function setEventId(?string $value): static
    {
        $this->eventId = $value;
        return $this;
    }

    public function getStartDate(): DateTime
    {
        return $this->startDate;
    }

    public function setStartDate(DateTime $value): static
    {
        $this->startDate = $value;
        return $this;
    }

    public function getEndDate(): ?DateTime
    {
        return $this->endDate;
    }

    public function setEndDate(?DateTime $value): static
    {
        $this->endDate = $value;
        return $this;
    }

    public function getLocation(): ?string
    {
        return HtmlDecode($this->location);
    }

    public function setLocation(?string $value): static
    {
        $this->location = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getMenu(): string
    {
        return HtmlDecode($this->menu);
    }

    public function setMenu(string $value): static
    {
        $this->menu = RemoveXss($value);
        return $this;
    }

    public function getDecor(): ?string
    {
        return HtmlDecode($this->decor);
    }

    public function setDecor(?string $value): static
    {
        $this->decor = RemoveXss($value);
        return $this;
    }
}
