<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "family_event_estimate" table
 */
#[Entity]
#[Table(name: "family_event_estimate")]
class FamilyEventEstimate extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "family_id", type: "integer", nullable: true)]
    private ?int $familyId;

    #[Column(name: "event_id", type: "smallint", nullable: true)]
    private ?int $eventId;

    #[Column(name: "event_1", type: "smallint", nullable: true)]
    private ?int $event1;

    #[Column(name: "event_2", type: "smallint", nullable: true)]
    private ?int $event2;

    #[Column(name: "event_3", type: "smallint", nullable: true)]
    private ?int $event3;

    #[Column(name: "event_4", type: "smallint", nullable: true)]
    private ?int $event4;

    #[Column(name: "event_5", type: "smallint", nullable: true)]
    private ?int $event5;

    #[Column(name: "event_6", type: "smallint", nullable: true)]
    private ?int $event6;

    #[Column(name: "event_7", type: "smallint", nullable: true)]
    private ?int $event7;

    #[Column(name: "event_8", type: "smallint", nullable: true)]
    private ?int $event8;

    #[Column(name: "event_9", type: "smallint", nullable: true)]
    private ?int $event9;

    #[Column(name: "event_10", type: "smallint", nullable: true)]
    private ?int $event10;

    #[Column(name: "event_11", type: "smallint")]
    private int $event11;

    #[Column(name: "event_12", type: "smallint")]
    private int $event12;

    #[Column(name: "event_13", type: "smallint")]
    private int $event13;

    #[Column(name: "event_14", type: "smallint")]
    private int $event14;

    #[Column(name: "event_15", type: "smallint")]
    private int $event15;

    #[Column(name: "event_16", type: "smallint")]
    private int $event16;

    #[Column(name: "event_17", type: "smallint")]
    private int $event17;

    #[Column(name: "event_18", type: "smallint")]
    private int $event18;

    #[Column(name: "event_19", type: "smallint")]
    private int $event19;

    #[Column(name: "event_20", type: "smallint")]
    private int $event20;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->event1 = 0;
        $this->event2 = 0;
        $this->event3 = 0;
        $this->event4 = 0;
        $this->event5 = 0;
        $this->event6 = 0;
        $this->event7 = 0;
        $this->event8 = 0;
        $this->event9 = 0;
        $this->event10 = 0;
        $this->event11 = 0;
        $this->event12 = 0;
        $this->event13 = 0;
        $this->event14 = 0;
        $this->event15 = 0;
        $this->event16 = 0;
        $this->event17 = 0;
        $this->event18 = 0;
        $this->event19 = 0;
        $this->event20 = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getFamilyId(): ?int
    {
        return $this->familyId;
    }

    public function setFamilyId(?int $value): static
    {
        $this->familyId = $value;
        return $this;
    }

    public function getEventId(): ?int
    {
        return $this->eventId;
    }

    public function setEventId(?int $value): static
    {
        $this->eventId = $value;
        return $this;
    }

    public function getEvent1(): ?int
    {
        return $this->event1;
    }

    public function setEvent1(?int $value): static
    {
        $this->event1 = $value;
        return $this;
    }

    public function getEvent2(): ?int
    {
        return $this->event2;
    }

    public function setEvent2(?int $value): static
    {
        $this->event2 = $value;
        return $this;
    }

    public function getEvent3(): ?int
    {
        return $this->event3;
    }

    public function setEvent3(?int $value): static
    {
        $this->event3 = $value;
        return $this;
    }

    public function getEvent4(): ?int
    {
        return $this->event4;
    }

    public function setEvent4(?int $value): static
    {
        $this->event4 = $value;
        return $this;
    }

    public function getEvent5(): ?int
    {
        return $this->event5;
    }

    public function setEvent5(?int $value): static
    {
        $this->event5 = $value;
        return $this;
    }

    public function getEvent6(): ?int
    {
        return $this->event6;
    }

    public function setEvent6(?int $value): static
    {
        $this->event6 = $value;
        return $this;
    }

    public function getEvent7(): ?int
    {
        return $this->event7;
    }

    public function setEvent7(?int $value): static
    {
        $this->event7 = $value;
        return $this;
    }

    public function getEvent8(): ?int
    {
        return $this->event8;
    }

    public function setEvent8(?int $value): static
    {
        $this->event8 = $value;
        return $this;
    }

    public function getEvent9(): ?int
    {
        return $this->event9;
    }

    public function setEvent9(?int $value): static
    {
        $this->event9 = $value;
        return $this;
    }

    public function getEvent10(): ?int
    {
        return $this->event10;
    }

    public function setEvent10(?int $value): static
    {
        $this->event10 = $value;
        return $this;
    }

    public function getEvent11(): int
    {
        return $this->event11;
    }

    public function setEvent11(int $value): static
    {
        $this->event11 = $value;
        return $this;
    }

    public function getEvent12(): int
    {
        return $this->event12;
    }

    public function setEvent12(int $value): static
    {
        $this->event12 = $value;
        return $this;
    }

    public function getEvent13(): int
    {
        return $this->event13;
    }

    public function setEvent13(int $value): static
    {
        $this->event13 = $value;
        return $this;
    }

    public function getEvent14(): int
    {
        return $this->event14;
    }

    public function setEvent14(int $value): static
    {
        $this->event14 = $value;
        return $this;
    }

    public function getEvent15(): int
    {
        return $this->event15;
    }

    public function setEvent15(int $value): static
    {
        $this->event15 = $value;
        return $this;
    }

    public function getEvent16(): int
    {
        return $this->event16;
    }

    public function setEvent16(int $value): static
    {
        $this->event16 = $value;
        return $this;
    }

    public function getEvent17(): int
    {
        return $this->event17;
    }

    public function setEvent17(int $value): static
    {
        $this->event17 = $value;
        return $this;
    }

    public function getEvent18(): int
    {
        return $this->event18;
    }

    public function setEvent18(int $value): static
    {
        $this->event18 = $value;
        return $this;
    }

    public function getEvent19(): int
    {
        return $this->event19;
    }

    public function setEvent19(int $value): static
    {
        $this->event19 = $value;
        return $this;
    }

    public function getEvent20(): int
    {
        return $this->event20;
    }

    public function setEvent20(int $value): static
    {
        $this->event20 = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
