<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "exportlog" table
 */
#[Entity]
#[Table(name: "exportlog")]
class Exportlog extends AbstractEntity
{
    #[Id]
    #[Column(type: "string", unique: true)]
    private string $fileId;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "string")]
    private string $user;

    #[Column(type: "string")]
    private string $exporttype;

    #[Column(name: "`table`", options: ["name" => "table"], type: "string")]
    private string $table;

    #[Column(type: "string", nullable: true)]
    private ?string $keyvalue;

    #[Column(type: "string")]
    private string $filename;

    #[Column(type: "text")]
    private string $request;

    public function getFileId(): string
    {
        return $this->fileId;
    }

    public function setFileId(string $value): static
    {
        $this->fileId = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getUser(): string
    {
        return HtmlDecode($this->user);
    }

    public function setUser(string $value): static
    {
        $this->user = RemoveXss($value);
        return $this;
    }

    public function getExporttype(): string
    {
        return HtmlDecode($this->exporttype);
    }

    public function setExporttype(string $value): static
    {
        $this->exporttype = RemoveXss($value);
        return $this;
    }

    public function getTable(): string
    {
        return HtmlDecode($this->table);
    }

    public function setTable(string $value): static
    {
        $this->table = RemoveXss($value);
        return $this;
    }

    public function getKeyvalue(): ?string
    {
        return HtmlDecode($this->keyvalue);
    }

    public function setKeyvalue(?string $value): static
    {
        $this->keyvalue = RemoveXss($value);
        return $this;
    }

    public function getFilename(): string
    {
        return HtmlDecode($this->filename);
    }

    public function setFilename(string $value): static
    {
        $this->filename = RemoveXss($value);
        return $this;
    }

    public function getRequest(): string
    {
        return HtmlDecode($this->request);
    }

    public function setRequest(string $value): static
    {
        $this->request = RemoveXss($value);
        return $this;
    }
}
