<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "documents" table
 */
#[Entity]
#[Table(name: "documents")]
class Document extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $type;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dated;

    #[Column(type: "string")]
    private string $title;

    #[Column(type: "string")]
    private string $description;

    #[Column(type: "string")]
    private string $uploads;

    #[Column(name: "d_from", type: "string", nullable: true)]
    private ?string $dFrom;

    #[Column(name: "d_to", type: "string", nullable: true)]
    private ?string $dTo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getType(): ?string
    {
        return HtmlDecode($this->type);
    }

    public function setType(?string $value): static
    {
        $this->type = RemoveXss($value);
        return $this;
    }

    public function getDated(): ?DateTime
    {
        return $this->dated;
    }

    public function setDated(?DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getTitle(): string
    {
        return HtmlDecode($this->title);
    }

    public function setTitle(string $value): static
    {
        $this->title = RemoveXss($value);
        return $this;
    }

    public function getDescription(): string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getUploads(): string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getDFrom(): ?string
    {
        return HtmlDecode($this->dFrom);
    }

    public function setDFrom(?string $value): static
    {
        $this->dFrom = RemoveXss($value);
        return $this;
    }

    public function getDTo(): ?string
    {
        return HtmlDecode($this->dTo);
    }

    public function setDTo(?string $value): static
    {
        $this->dTo = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
