<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "dashboard" table
 */
#[Entity]
#[Table(name: "dashboard")]
class Dashboard extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "item_group", type: "integer")]
    private int $itemGroup;

    #[Column(type: "string", nullable: true)]
    private ?string $icon;

    #[Column(type: "string", nullable: true)]
    private ?string $image;

    #[Column(name: "target_window", type: "string")]
    private string $targetWindow;

    #[Column(type: "string")]
    private string $title;

    #[Column(name: "sub_title", type: "text", nullable: true)]
    private ?string $subTitle;

    #[Column(name: "url_link", type: "string", nullable: true)]
    private ?string $urlLink;

    #[Column(type: "text", nullable: true)]
    private ?string $code;

    #[Column(name: "order_by", type: "smallint")]
    private int $orderBy;

    #[Column(name: "user_level", type: "string", nullable: true)]
    private ?string $userLevel;

    #[Column(name: "group_by", type: "string", nullable: true)]
    private ?string $groupBy;

    #[Column(name: "sub_group_by", type: "string", nullable: true)]
    private ?string $subGroupBy;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->itemGroup = 1;
        $this->targetWindow = "_self";
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getItemGroup(): int
    {
        return $this->itemGroup;
    }

    public function setItemGroup(int $value): static
    {
        $this->itemGroup = $value;
        return $this;
    }

    public function getIcon(): ?string
    {
        return HtmlDecode($this->icon);
    }

    public function setIcon(?string $value): static
    {
        $this->icon = RemoveXss($value);
        return $this;
    }

    public function getImage(): ?string
    {
        return HtmlDecode($this->image);
    }

    public function setImage(?string $value): static
    {
        $this->image = RemoveXss($value);
        return $this;
    }

    public function getTargetWindow(): string
    {
        return HtmlDecode($this->targetWindow);
    }

    public function setTargetWindow(string $value): static
    {
        $this->targetWindow = RemoveXss($value);
        return $this;
    }

    public function getTitle(): string
    {
        return HtmlDecode($this->title);
    }

    public function setTitle(string $value): static
    {
        $this->title = RemoveXss($value);
        return $this;
    }

    public function getSubTitle(): ?string
    {
        return HtmlDecode($this->subTitle);
    }

    public function setSubTitle(?string $value): static
    {
        $this->subTitle = RemoveXss($value);
        return $this;
    }

    public function getUrlLink(): ?string
    {
        return HtmlDecode($this->urlLink);
    }

    public function setUrlLink(?string $value): static
    {
        $this->urlLink = RemoveXss($value);
        return $this;
    }

    public function getCode(): ?string
    {
        return $this->code;
    }

    public function setCode(?string $value): static
    {
        $this->code = $value;
        return $this;
    }

    public function getOrderBy(): int
    {
        return $this->orderBy;
    }

    public function setOrderBy(int $value): static
    {
        $this->orderBy = $value;
        return $this;
    }

    public function getUserLevel(): ?string
    {
        return HtmlDecode($this->userLevel);
    }

    public function setUserLevel(?string $value): static
    {
        $this->userLevel = RemoveXss($value);
        return $this;
    }

    public function getGroupBy(): ?string
    {
        return HtmlDecode($this->groupBy);
    }

    public function setGroupBy(?string $value): static
    {
        $this->groupBy = RemoveXss($value);
        return $this;
    }

    public function getSubGroupBy(): ?string
    {
        return HtmlDecode($this->subGroupBy);
    }

    public function setSubGroupBy(?string $value): static
    {
        $this->subGroupBy = RemoveXss($value);
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
