<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "d_b_view" table
 */
#[Entity]
#[Table(name: "d_b_view")]
class DBView extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string")]
    private string $item;

    #[Column(type: "string")]
    private string $grp;

    #[Column(name: "d_n", type: "string")]
    private string $dN;

    #[Column(name: "d_n_text", type: "string")]
    private string $dNText;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "integer")]
    private int $opeartor;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->status = 1;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getItem(): string
    {
        return HtmlDecode($this->item);
    }

    public function setItem(string $value): static
    {
        $this->item = RemoveXss($value);
        return $this;
    }

    public function getGrp(): string
    {
        return HtmlDecode($this->grp);
    }

    public function setGrp(string $value): static
    {
        $this->grp = RemoveXss($value);
        return $this;
    }

    public function getDN(): string
    {
        return HtmlDecode($this->dN);
    }

    public function setDN(string $value): static
    {
        $this->dN = RemoveXss($value);
        return $this;
    }

    public function getDNText(): string
    {
        return HtmlDecode($this->dNText);
    }

    public function setDNText(string $value): static
    {
        $this->dNText = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOpeartor(): int
    {
        return $this->opeartor;
    }

    public function setOpeartor(int $value): static
    {
        $this->opeartor = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
