<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "customized_message" table
 */
#[Entity]
#[Table(name: "customized_message")]
class CustomizedMessage extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $reference;

    #[Column(name: "message_type", type: "smallint", nullable: true)]
    private ?int $messageType;

    #[Column(name: "wa_type", type: "smallint", nullable: true)]
    private ?int $waType;

    #[Column(name: "wa_id", type: "smallint")]
    private int $waId;

    #[Column(name: "mobile_no", type: "text")]
    private string $mobileNo;

    #[Column(type: "text", nullable: true)]
    private ?string $email;

    #[Column(type: "string")]
    private string $subject;

    #[Column(type: "text", nullable: true)]
    private ?string $message;

    #[Column(type: "text", nullable: true)]
    private ?string $sms;

    #[Column(type: "string", nullable: true)]
    private ?string $uploads;

    #[Column(name: "b_type", type: "smallint", nullable: true)]
    private ?int $bType;

    #[Column(name: "b_1", type: "string", nullable: true)]
    private ?string $b1;

    #[Column(name: "b_2", type: "string", nullable: true)]
    private ?string $b2;

    #[Column(name: "b_3", type: "string", nullable: true)]
    private ?string $b3;

    #[Column(name: "b_4", type: "string", nullable: true)]
    private ?string $b4;

    #[Column(name: "trigger_time", type: "datetime")]
    private DateTime $triggerTime;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->reference = ((isset($_GET["ref"]))? 'REQID:'.$_GET["ref"]:"");
        $this->status = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getReference(): ?string
    {
        return HtmlDecode($this->reference);
    }

    public function setReference(?string $value): static
    {
        $this->reference = RemoveXss($value);
        return $this;
    }

    public function getMessageType(): ?int
    {
        return $this->messageType;
    }

    public function setMessageType(?int $value): static
    {
        $this->messageType = $value;
        return $this;
    }

    public function getWaType(): ?int
    {
        return $this->waType;
    }

    public function setWaType(?int $value): static
    {
        $this->waType = $value;
        return $this;
    }

    public function getWaId(): int
    {
        return $this->waId;
    }

    public function setWaId(int $value): static
    {
        $this->waId = $value;
        return $this;
    }

    public function getMobileNo(): string
    {
        return HtmlDecode($this->mobileNo);
    }

    public function setMobileNo(string $value): static
    {
        $this->mobileNo = RemoveXss($value);
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getSubject(): string
    {
        return HtmlDecode($this->subject);
    }

    public function setSubject(string $value): static
    {
        $this->subject = RemoveXss($value);
        return $this;
    }

    public function getMessage(): ?string
    {
        return HtmlDecode($this->message);
    }

    public function setMessage(?string $value): static
    {
        $this->message = RemoveXss($value);
        return $this;
    }

    public function getSms(): ?string
    {
        return HtmlDecode($this->sms);
    }

    public function setSms(?string $value): static
    {
        $this->sms = RemoveXss($value);
        return $this;
    }

    public function getUploads(): ?string
    {
        return HtmlDecode($this->uploads);
    }

    public function setUploads(?string $value): static
    {
        $this->uploads = RemoveXss($value);
        return $this;
    }

    public function getBType(): ?int
    {
        return $this->bType;
    }

    public function setBType(?int $value): static
    {
        $this->bType = $value;
        return $this;
    }

    public function getB1(): ?string
    {
        return HtmlDecode($this->b1);
    }

    public function setB1(?string $value): static
    {
        $this->b1 = RemoveXss($value);
        return $this;
    }

    public function getB2(): ?string
    {
        return HtmlDecode($this->b2);
    }

    public function setB2(?string $value): static
    {
        $this->b2 = RemoveXss($value);
        return $this;
    }

    public function getB3(): ?string
    {
        return HtmlDecode($this->b3);
    }

    public function setB3(?string $value): static
    {
        $this->b3 = RemoveXss($value);
        return $this;
    }

    public function getB4(): ?string
    {
        return HtmlDecode($this->b4);
    }

    public function setB4(?string $value): static
    {
        $this->b4 = RemoveXss($value);
        return $this;
    }

    public function getTriggerTime(): DateTime
    {
        return $this->triggerTime;
    }

    public function setTriggerTime(DateTime $value): static
    {
        $this->triggerTime = $value;
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
