<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "cost_calculator_detailed" table
 */
#[Entity]
#[Table(name: "cost_calculator_detailed")]
class CostCalculatorDetailed extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "cc_id", type: "smallint", nullable: true)]
    private ?int $ccId;

    #[Column(type: "string")]
    private string $rid;

    #[Column(type: "decimal", nullable: true)]
    private ?string $sqm;

    #[Column(type: "smallint", nullable: true)]
    private ?int $item;

    #[Column(name: "packing_type", type: "smallint", nullable: true)]
    private ?int $packingType;

    #[Column(type: "integer", nullable: true)]
    private ?int $method;

    #[Column(type: "decimal")]
    private string $qty;

    #[Column(name: "last_price", type: "decimal", nullable: true)]
    private ?string $lastPrice;

    #[Column(type: "decimal", nullable: true)]
    private ?string $amount;

    #[Column(type: "string", nullable: true)]
    private ?string $process;

    #[Column(name: "w_cm", type: "smallint", nullable: true)]
    private ?int $wCm;

    #[Column(name: "l_cm", type: "smallint", nullable: true)]
    private ?int $lCm;

    #[Column(type: "string", nullable: true)]
    private ?string $description;

    #[Column(type: "decimal", nullable: true)]
    private ?string $overhead;

    #[Column(type: "decimal", nullable: true)]
    private ?string $margin;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getCcId(): ?int
    {
        return $this->ccId;
    }

    public function setCcId(?int $value): static
    {
        $this->ccId = $value;
        return $this;
    }

    public function getRid(): string
    {
        return HtmlDecode($this->rid);
    }

    public function setRid(string $value): static
    {
        $this->rid = RemoveXss($value);
        return $this;
    }

    public function getSqm(): ?string
    {
        return $this->sqm;
    }

    public function setSqm(?string $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getItem(): ?int
    {
        return $this->item;
    }

    public function setItem(?int $value): static
    {
        $this->item = $value;
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getMethod(): ?int
    {
        return $this->method;
    }

    public function setMethod(?int $value): static
    {
        $this->method = $value;
        return $this;
    }

    public function getQty(): string
    {
        return $this->qty;
    }

    public function setQty(string $value): static
    {
        $this->qty = $value;
        return $this;
    }

    public function getLastPrice(): ?string
    {
        return $this->lastPrice;
    }

    public function setLastPrice(?string $value): static
    {
        $this->lastPrice = $value;
        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getProcess(): ?string
    {
        return HtmlDecode($this->process);
    }

    public function setProcess(?string $value): static
    {
        $this->process = RemoveXss($value);
        return $this;
    }

    public function getWCm(): ?int
    {
        return $this->wCm;
    }

    public function setWCm(?int $value): static
    {
        $this->wCm = $value;
        return $this;
    }

    public function getLCm(): ?int
    {
        return $this->lCm;
    }

    public function setLCm(?int $value): static
    {
        $this->lCm = $value;
        return $this;
    }

    public function getDescription(): ?string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(?string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getOverhead(): ?string
    {
        return $this->overhead;
    }

    public function setOverhead(?string $value): static
    {
        $this->overhead = $value;
        return $this;
    }

    public function getMargin(): ?string
    {
        return $this->margin;
    }

    public function setMargin(?string $value): static
    {
        $this->margin = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
