<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "cost_calculator" table
 */
#[Entity]
#[Table(name: "cost_calculator")]
class CostCalculator extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "buyer_id", type: "smallint", nullable: true)]
    private ?int $buyerId;

    #[Column(type: "smallint", nullable: true)]
    private ?int $rid;

    #[Column(name: "batch_no", type: "smallint", nullable: true)]
    private ?int $batchNo;

    #[Column(name: "price_inr", type: "decimal", nullable: true)]
    private ?string $priceInr;

    #[Column(type: "smallint", nullable: true)]
    private ?int $shape;

    #[Column(name: "w_cm", type: "smallint", nullable: true)]
    private ?int $wCm;

    #[Column(name: "l_cm", type: "smallint", nullable: true)]
    private ?int $lCm;

    #[Column(name: "bom_percent", type: "decimal", nullable: true)]
    private ?string $bomPercent;

    #[Column(name: "process_percent", type: "decimal", nullable: true)]
    private ?string $processPercent;

    #[Column(name: "other_sqm", type: "decimal", nullable: true)]
    private ?string $otherSqm;

    #[Column(name: "margin_percent", type: "decimal", nullable: true)]
    private ?string $marginPercent;

    #[Column(type: "decimal", nullable: true)]
    private ?string $price;

    #[Column(type: "smallint", nullable: true)]
    private ?int $currency;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dated;

    #[Column(name: "packing_type", type: "smallint")]
    private int $packingType;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getBuyerId(): ?int
    {
        return $this->buyerId;
    }

    public function setBuyerId(?int $value): static
    {
        $this->buyerId = $value;
        return $this;
    }

    public function getRid(): ?int
    {
        return $this->rid;
    }

    public function setRid(?int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getBatchNo(): ?int
    {
        return $this->batchNo;
    }

    public function setBatchNo(?int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getPriceInr(): ?string
    {
        return $this->priceInr;
    }

    public function setPriceInr(?string $value): static
    {
        $this->priceInr = $value;
        return $this;
    }

    public function getShape(): ?int
    {
        return $this->shape;
    }

    public function setShape(?int $value): static
    {
        $this->shape = $value;
        return $this;
    }

    public function getWCm(): ?int
    {
        return $this->wCm;
    }

    public function setWCm(?int $value): static
    {
        $this->wCm = $value;
        return $this;
    }

    public function getLCm(): ?int
    {
        return $this->lCm;
    }

    public function setLCm(?int $value): static
    {
        $this->lCm = $value;
        return $this;
    }

    public function getBomPercent(): ?string
    {
        return $this->bomPercent;
    }

    public function setBomPercent(?string $value): static
    {
        $this->bomPercent = $value;
        return $this;
    }

    public function getProcessPercent(): ?string
    {
        return $this->processPercent;
    }

    public function setProcessPercent(?string $value): static
    {
        $this->processPercent = $value;
        return $this;
    }

    public function getOtherSqm(): ?string
    {
        return $this->otherSqm;
    }

    public function setOtherSqm(?string $value): static
    {
        $this->otherSqm = $value;
        return $this;
    }

    public function getMarginPercent(): ?string
    {
        return $this->marginPercent;
    }

    public function setMarginPercent(?string $value): static
    {
        $this->marginPercent = $value;
        return $this;
    }

    public function getPrice(): ?string
    {
        return $this->price;
    }

    public function setPrice(?string $value): static
    {
        $this->price = $value;
        return $this;
    }

    public function getCurrency(): ?int
    {
        return $this->currency;
    }

    public function setCurrency(?int $value): static
    {
        $this->currency = $value;
        return $this;
    }

    public function getDated(): ?DateTime
    {
        return $this->dated;
    }

    public function setDated(?DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getPackingType(): int
    {
        return $this->packingType;
    }

    public function setPackingType(int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
