<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "composition" table
 */
#[Entity]
#[Table(name: "composition")]
class Composition extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $grp;

    #[Column(type: "integer")]
    private int $wool;

    #[Column(type: "integer")]
    private int $viscose;

    #[Column(type: "integer")]
    private int $polyester;

    #[Column(type: "integer")]
    private int $cotton;

    #[Column(type: "integer")]
    private int $jute;

    #[Column(type: "integer")]
    private int $other;

    #[Column(name: "other_name", type: "string", nullable: true)]
    private ?string $otherName;

    #[Column(name: "description_type", type: "integer", nullable: true)]
    private ?int $descriptionType;

    #[Column(type: "string", nullable: true)]
    private ?string $code;

    #[Column(type: "string", nullable: true)]
    private ?string $composition;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "string", unique: true)]
    private string $uid;

    public function __construct()
    {
        $this->wool = 0;
        $this->viscose = 0;
        $this->polyester = 0;
        $this->cotton = 0;
        $this->jute = 0;
        $this->other = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): ?string
    {
        return HtmlDecode($this->grp);
    }

    public function setGrp(?string $value): static
    {
        $this->grp = RemoveXss($value);
        return $this;
    }

    public function getWool(): int
    {
        return $this->wool;
    }

    public function setWool(int $value): static
    {
        $this->wool = $value;
        return $this;
    }

    public function getViscose(): int
    {
        return $this->viscose;
    }

    public function setViscose(int $value): static
    {
        $this->viscose = $value;
        return $this;
    }

    public function getPolyester(): int
    {
        return $this->polyester;
    }

    public function setPolyester(int $value): static
    {
        $this->polyester = $value;
        return $this;
    }

    public function getCotton(): int
    {
        return $this->cotton;
    }

    public function setCotton(int $value): static
    {
        $this->cotton = $value;
        return $this;
    }

    public function getJute(): int
    {
        return $this->jute;
    }

    public function setJute(int $value): static
    {
        $this->jute = $value;
        return $this;
    }

    public function getOther(): int
    {
        return $this->other;
    }

    public function setOther(int $value): static
    {
        $this->other = $value;
        return $this;
    }

    public function getOtherName(): ?string
    {
        return HtmlDecode($this->otherName);
    }

    public function setOtherName(?string $value): static
    {
        $this->otherName = RemoveXss($value);
        return $this;
    }

    public function getDescriptionType(): ?int
    {
        return $this->descriptionType;
    }

    public function setDescriptionType(?int $value): static
    {
        $this->descriptionType = $value;
        return $this;
    }

    public function getCode(): ?string
    {
        return HtmlDecode($this->code);
    }

    public function setCode(?string $value): static
    {
        $this->code = RemoveXss($value);
        return $this;
    }

    public function getComposition(): ?string
    {
        return HtmlDecode($this->composition);
    }

    public function setComposition(?string $value): static
    {
        $this->composition = RemoveXss($value);
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getUid(): string
    {
        return HtmlDecode($this->uid);
    }

    public function setUid(string $value): static
    {
        $this->uid = RemoveXss($value);
        return $this;
    }
}
