<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "collection_log" table
 */
#[Entity]
#[Table(name: "collection_log")]
class CollectionLog extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint", nullable: true)]
    private ?int $location;

    #[Column(type: "smallint")]
    private int $agent;

    #[Column(name: "account_no", type: "integer")]
    private int $accountNo;

    #[Column(name: "emi_no", type: "smallint", nullable: true)]
    private ?int $emiNo;

    #[Column(type: "decimal")]
    private string $amount;

    #[Column(type: "decimal")]
    private string $panel;

    #[Column(type: "date")]
    private DateTime $dated;

    #[Column(name: "revised_date", type: "date", nullable: true)]
    private ?DateTime $revisedDate;

    #[Column(type: "string", nullable: true)]
    private ?string $updated;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "string")]
    private string $url;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getLocation(): ?int
    {
        return $this->location;
    }

    public function setLocation(?int $value): static
    {
        $this->location = $value;
        return $this;
    }

    public function getAgent(): int
    {
        return $this->agent;
    }

    public function setAgent(int $value): static
    {
        $this->agent = $value;
        return $this;
    }

    public function getAccountNo(): int
    {
        return $this->accountNo;
    }

    public function setAccountNo(int $value): static
    {
        $this->accountNo = $value;
        return $this;
    }

    public function getEmiNo(): ?int
    {
        return $this->emiNo;
    }

    public function setEmiNo(?int $value): static
    {
        $this->emiNo = $value;
        return $this;
    }

    public function getAmount(): string
    {
        return $this->amount;
    }

    public function setAmount(string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getPanel(): string
    {
        return $this->panel;
    }

    public function setPanel(string $value): static
    {
        $this->panel = $value;
        return $this;
    }

    public function getDated(): DateTime
    {
        return $this->dated;
    }

    public function setDated(DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getRevisedDate(): ?DateTime
    {
        return $this->revisedDate;
    }

    public function setRevisedDate(?DateTime $value): static
    {
        $this->revisedDate = $value;
        return $this;
    }

    public function getUpdated(): ?string
    {
        return HtmlDecode($this->updated);
    }

    public function setUpdated(?string $value): static
    {
        $this->updated = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getUrl(): string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }
}
