<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "code_exchange" table
 */
#[Entity]
#[Table(name: "code_exchange")]
class CodeExchange extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "integer")]
    private int $code;

    #[Column(name: "consume_by", type: "integer")]
    private int $consumeBy;

    #[Column(name: "code_value", type: "string", nullable: true)]
    private ?string $codeValue;

    #[Column(name: "consume_by_value", type: "string", nullable: true)]
    private ?string $consumeByValue;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->code = (isset($_GET["code"]))? $_GET["code"]:"";
        $this->consumeBy = (isset($_GET["code"]))? $_GET["code"]:"";
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getCode(): int
    {
        return $this->code;
    }

    public function setCode(int $value): static
    {
        $this->code = $value;
        return $this;
    }

    public function getConsumeBy(): int
    {
        return $this->consumeBy;
    }

    public function setConsumeBy(int $value): static
    {
        $this->consumeBy = $value;
        return $this;
    }

    public function getCodeValue(): ?string
    {
        return HtmlDecode($this->codeValue);
    }

    public function setCodeValue(?string $value): static
    {
        $this->codeValue = RemoveXss($value);
        return $this;
    }

    public function getConsumeByValue(): ?string
    {
        return HtmlDecode($this->consumeByValue);
    }

    public function setConsumeByValue(?string $value): static
    {
        $this->consumeByValue = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
