<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "client_hardware_data" table
 */
#[Entity]
#[Table(name: "client_hardware_data")]
class ClientHardwareDatum extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "customer_grp", type: "string")]
    private string $customerGrp;

    #[Column(type: "string", nullable: true)]
    private ?string $ref;

    #[Column(name: "partner_id", type: "smallint", nullable: true)]
    private ?int $partnerId;

    #[Column(name: "name_ref", type: "string", nullable: true)]
    private ?string $nameRef;

    #[Column(name: "city_name", type: "string", nullable: true)]
    private ?string $cityName;

    #[Column(type: "string", nullable: true)]
    private ?string $area;

    #[Column(name: "billing_name", type: "string", nullable: true)]
    private ?string $billingName;

    #[Column(type: "string")]
    private string $address;

    #[Column(name: "personal_ref", type: "string", nullable: true)]
    private ?string $personalRef;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(name: "s_grp", type: "smallint")]
    private int $sGrp;

    #[Column(type: "string", nullable: true)]
    private ?string $product;

    #[Column(type: "smallint")]
    private int $rid;

    #[Column(name: "rid_1", type: "string", nullable: true)]
    private ?string $rid1;

    #[Column(name: "harward_code", type: "string", nullable: true)]
    private ?string $harwardCode;

    #[Column(name: "serial_no", type: "string", nullable: true)]
    private ?string $serialNo;

    #[Column(name: "invoice_no", type: "string", nullable: true)]
    private ?string $invoiceNo;

    #[Column(name: "invoice_date", type: "date", nullable: true)]
    private ?DateTime $invoiceDate;

    #[Column(name: "first_counter", type: "integer", nullable: true)]
    private ?int $firstCounter;

    #[Column(type: "integer", nullable: true)]
    private ?int $guarantee;

    #[Column(name: "valid_till", type: "date", nullable: true)]
    private ?DateTime $validTill;

    #[Column(name: "valid_till_counter", type: "integer", nullable: true)]
    private ?int $validTillCounter;

    #[Column(name: "free_service", type: "smallint", nullable: true)]
    private ?int $freeService;

    #[Column(name: "toner_life", type: "integer", nullable: true)]
    private ?int $tonerLife;

    #[Column(name: "drum_life", type: "integer", nullable: true)]
    private ?int $drumLife;

    #[Column(name: "developer_life", type: "integer", nullable: true)]
    private ?int $developerLife;

    #[Column(name: "date_install", type: "date", nullable: true)]
    private ?DateTime $dateInstall;

    #[Column(name: "date_start", type: "date", nullable: true)]
    private ?DateTime $dateStart;

    #[Column(type: "string", nullable: true)]
    private ?string $remark;

    #[Column(type: "smallint")]
    private int $status;

    #[Column(name: "schedule_service_type", type: "smallint")]
    private int $scheduleServiceType;

    #[Column(name: "schedule_service_interval_days", type: "smallint")]
    private int $scheduleServiceIntervalDays;

    #[Column(name: "schedule_service_updated_till", type: "date")]
    private DateTime $scheduleServiceUpdatedTill;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "copy_average_1", type: "integer", nullable: true)]
    private ?int $copyAverage1;

    #[Column(name: "copy_average_2", type: "integer", nullable: true)]
    private ?int $copyAverage2;

    #[Column(name: "copy_average_3", type: "integer", nullable: true)]
    private ?int $copyAverage3;

    public function __construct()
    {
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getCustomerGrp(): string
    {
        return HtmlDecode($this->customerGrp);
    }

    public function setCustomerGrp(string $value): static
    {
        $this->customerGrp = RemoveXss($value);
        return $this;
    }

    public function getRef(): ?string
    {
        return HtmlDecode($this->ref);
    }

    public function setRef(?string $value): static
    {
        $this->ref = RemoveXss($value);
        return $this;
    }

    public function getPartnerId(): ?int
    {
        return $this->partnerId;
    }

    public function setPartnerId(?int $value): static
    {
        $this->partnerId = $value;
        return $this;
    }

    public function getNameRef(): ?string
    {
        return HtmlDecode($this->nameRef);
    }

    public function setNameRef(?string $value): static
    {
        $this->nameRef = RemoveXss($value);
        return $this;
    }

    public function getCityName(): ?string
    {
        return HtmlDecode($this->cityName);
    }

    public function setCityName(?string $value): static
    {
        $this->cityName = RemoveXss($value);
        return $this;
    }

    public function getArea(): ?string
    {
        return HtmlDecode($this->area);
    }

    public function setArea(?string $value): static
    {
        $this->area = RemoveXss($value);
        return $this;
    }

    public function getBillingName(): ?string
    {
        return HtmlDecode($this->billingName);
    }

    public function setBillingName(?string $value): static
    {
        $this->billingName = RemoveXss($value);
        return $this;
    }

    public function getAddress(): string
    {
        return HtmlDecode($this->address);
    }

    public function setAddress(string $value): static
    {
        $this->address = RemoveXss($value);
        return $this;
    }

    public function getPersonalRef(): ?string
    {
        return HtmlDecode($this->personalRef);
    }

    public function setPersonalRef(?string $value): static
    {
        $this->personalRef = RemoveXss($value);
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): ?string
    {
        return HtmlDecode($this->product);
    }

    public function setProduct(?string $value): static
    {
        $this->product = RemoveXss($value);
        return $this;
    }

    public function getRid(): int
    {
        return $this->rid;
    }

    public function setRid(int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getRid1(): ?string
    {
        return HtmlDecode($this->rid1);
    }

    public function setRid1(?string $value): static
    {
        $this->rid1 = RemoveXss($value);
        return $this;
    }

    public function getHarwardCode(): ?string
    {
        return HtmlDecode($this->harwardCode);
    }

    public function setHarwardCode(?string $value): static
    {
        $this->harwardCode = RemoveXss($value);
        return $this;
    }

    public function getSerialNo(): ?string
    {
        return HtmlDecode($this->serialNo);
    }

    public function setSerialNo(?string $value): static
    {
        $this->serialNo = RemoveXss($value);
        return $this;
    }

    public function getInvoiceNo(): ?string
    {
        return HtmlDecode($this->invoiceNo);
    }

    public function setInvoiceNo(?string $value): static
    {
        $this->invoiceNo = RemoveXss($value);
        return $this;
    }

    public function getInvoiceDate(): ?DateTime
    {
        return $this->invoiceDate;
    }

    public function setInvoiceDate(?DateTime $value): static
    {
        $this->invoiceDate = $value;
        return $this;
    }

    public function getFirstCounter(): ?int
    {
        return $this->firstCounter;
    }

    public function setFirstCounter(?int $value): static
    {
        $this->firstCounter = $value;
        return $this;
    }

    public function getGuarantee(): ?int
    {
        return $this->guarantee;
    }

    public function setGuarantee(?int $value): static
    {
        $this->guarantee = $value;
        return $this;
    }

    public function getValidTill(): ?DateTime
    {
        return $this->validTill;
    }

    public function setValidTill(?DateTime $value): static
    {
        $this->validTill = $value;
        return $this;
    }

    public function getValidTillCounter(): ?int
    {
        return $this->validTillCounter;
    }

    public function setValidTillCounter(?int $value): static
    {
        $this->validTillCounter = $value;
        return $this;
    }

    public function getFreeService(): ?int
    {
        return $this->freeService;
    }

    public function setFreeService(?int $value): static
    {
        $this->freeService = $value;
        return $this;
    }

    public function getTonerLife(): ?int
    {
        return $this->tonerLife;
    }

    public function setTonerLife(?int $value): static
    {
        $this->tonerLife = $value;
        return $this;
    }

    public function getDrumLife(): ?int
    {
        return $this->drumLife;
    }

    public function setDrumLife(?int $value): static
    {
        $this->drumLife = $value;
        return $this;
    }

    public function getDeveloperLife(): ?int
    {
        return $this->developerLife;
    }

    public function setDeveloperLife(?int $value): static
    {
        $this->developerLife = $value;
        return $this;
    }

    public function getDateInstall(): ?DateTime
    {
        return $this->dateInstall;
    }

    public function setDateInstall(?DateTime $value): static
    {
        $this->dateInstall = $value;
        return $this;
    }

    public function getDateStart(): ?DateTime
    {
        return $this->dateStart;
    }

    public function setDateStart(?DateTime $value): static
    {
        $this->dateStart = $value;
        return $this;
    }

    public function getRemark(): ?string
    {
        return HtmlDecode($this->remark);
    }

    public function setRemark(?string $value): static
    {
        $this->remark = RemoveXss($value);
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getScheduleServiceType(): int
    {
        return $this->scheduleServiceType;
    }

    public function setScheduleServiceType(int $value): static
    {
        $this->scheduleServiceType = $value;
        return $this;
    }

    public function getScheduleServiceIntervalDays(): int
    {
        return $this->scheduleServiceIntervalDays;
    }

    public function setScheduleServiceIntervalDays(int $value): static
    {
        $this->scheduleServiceIntervalDays = $value;
        return $this;
    }

    public function getScheduleServiceUpdatedTill(): DateTime
    {
        return $this->scheduleServiceUpdatedTill;
    }

    public function setScheduleServiceUpdatedTill(DateTime $value): static
    {
        $this->scheduleServiceUpdatedTill = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getCopyAverage1(): ?int
    {
        return $this->copyAverage1;
    }

    public function setCopyAverage1(?int $value): static
    {
        $this->copyAverage1 = $value;
        return $this;
    }

    public function getCopyAverage2(): ?int
    {
        return $this->copyAverage2;
    }

    public function setCopyAverage2(?int $value): static
    {
        $this->copyAverage2 = $value;
        return $this;
    }

    public function getCopyAverage3(): ?int
    {
        return $this->copyAverage3;
    }

    public function setCopyAverage3(?int $value): static
    {
        $this->copyAverage3 = $value;
        return $this;
    }
}
