<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "cart_b_live" table
 */
#[Entity]
#[Table(name: "cart_b_live")]
class CartBLive extends AbstractEntity
{
    #[Column(type: "integer")]
    private int $id;

    #[Column(type: "smallint", nullable: true)]
    private ?int $po;

    #[Column(name: "partner_order_no", type: "string", nullable: true)]
    private ?string $partnerOrderNo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(type: "string", nullable: true)]
    private ?string $rid;

    #[Column(name: "order_quantity", type: "decimal")]
    private string $orderQuantity;

    #[Column(name: "sale_quantity", type: "decimal")]
    private string $saleQuantity;

    #[Column(name: "processed_quantity", type: "decimal")]
    private string $processedQuantity;

    #[Column(name: "pending_quantity", type: "decimal")]
    private string $pendingQuantity;

    #[Column(name: "partner_id", type: "integer", nullable: true)]
    private ?int $partnerId;

    #[Column(name: "company_id", type: "integer", nullable: true)]
    private ?int $companyId;

    #[Column(name: "dispatch_date", type: "date", nullable: true)]
    private ?DateTime $dispatchDate;

    #[Column(name: "despatch_week", type: "smallint", nullable: true)]
    private ?int $despatchWeek;

    #[Column(name: "packing_type", type: "smallint", nullable: true)]
    private ?int $packingType;

    #[Column(name: "partner_order_date", type: "date", nullable: true)]
    private ?DateTime $partnerOrderDate;

    public function __construct()
    {
        $this->id = 0;
        $this->po = 0;
        $this->partnerOrderNo = ((isset($_GET["POD"]))? $_GET["POD"]:((isset($_COOKIE["POD"]))? $_COOKIE["POD"]:''));
        $this->grp = ((isset($_GET["grp"]))? $_GET["grp"]:((isset($_COOKIE["grp"]))? $_COOKIE["grp"]:''));
        $this->sGrp = ((isset($_GET["s_grp"]))? $_GET["s_grp"]:((isset($_COOKIE["s_grp"]))? $_COOKIE["s_grp"]:''));
        $this->product = ((isset($_GET["product"]))? $_GET["product"]:((isset($_COOKIE["product"]))? $_COOKIE["product"]:''));
        $this->orderQuantity = "0.00";
        $this->saleQuantity = "0.00";
        $this->processedQuantity = "0.00";
        $this->pendingQuantity = "0.00";
        $this->partnerId = ((isset($_GET["PID"]))? $_GET["PID"]:((isset($_COOKIE["partner_id"]))? $_COOKIE["partner_id"]:''));
        $this->companyId = ((isset($_GET["CID"]))? $_GET["CID"]:((isset($_COOKIE["company_id"]))? $_COOKIE["company_id"]:User_Company_ID()));
        $this->packingType = ((isset($_GET["pt"]))? $_GET["pt"]:((isset($_COOKIE["pt"]))? $_COOKIE["pt"]:301));
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getPartnerOrderNo(): ?string
    {
        return HtmlDecode($this->partnerOrderNo);
    }

    public function setPartnerOrderNo(?string $value): static
    {
        $this->partnerOrderNo = RemoveXss($value);
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRid(): ?string
    {
        return HtmlDecode($this->rid);
    }

    public function setRid(?string $value): static
    {
        $this->rid = RemoveXss($value);
        return $this;
    }

    public function getOrderQuantity(): string
    {
        return $this->orderQuantity;
    }

    public function setOrderQuantity(string $value): static
    {
        $this->orderQuantity = $value;
        return $this;
    }

    public function getSaleQuantity(): string
    {
        return $this->saleQuantity;
    }

    public function setSaleQuantity(string $value): static
    {
        $this->saleQuantity = $value;
        return $this;
    }

    public function getProcessedQuantity(): string
    {
        return $this->processedQuantity;
    }

    public function setProcessedQuantity(string $value): static
    {
        $this->processedQuantity = $value;
        return $this;
    }

    public function getPendingQuantity(): string
    {
        return $this->pendingQuantity;
    }

    public function setPendingQuantity(string $value): static
    {
        $this->pendingQuantity = $value;
        return $this;
    }

    public function getPartnerId(): ?int
    {
        return $this->partnerId;
    }

    public function setPartnerId(?int $value): static
    {
        $this->partnerId = $value;
        return $this;
    }

    public function getCompanyId(): ?int
    {
        return $this->companyId;
    }

    public function setCompanyId(?int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getDispatchDate(): ?DateTime
    {
        return $this->dispatchDate;
    }

    public function setDispatchDate(?DateTime $value): static
    {
        $this->dispatchDate = $value;
        return $this;
    }

    public function getDespatchWeek(): ?int
    {
        return $this->despatchWeek;
    }

    public function setDespatchWeek(?int $value): static
    {
        $this->despatchWeek = $value;
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getPartnerOrderDate(): ?DateTime
    {
        return $this->partnerOrderDate;
    }

    public function setPartnerOrderDate(?DateTime $value): static
    {
        $this->partnerOrderDate = $value;
        return $this;
    }
}
