<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "carpet_setup" table
 */
#[Entity]
#[Table(name: "carpet_setup")]
class CarpetSetup extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    private int $id;

    #[Column(name: "cs_min_width", type: "decimal", nullable: true)]
    private ?string $csMinWidth;

    #[Column(name: "cs_min_qty", type: "smallint", nullable: true)]
    private ?int $csMinQty;

    #[Column(name: "payment_sqm", type: "string")]
    private string $paymentSqm;

    #[Column(name: "payment_sqm_byepass_category", type: "string")]
    private string $paymentSqmByepassCategory;

    #[Column(name: "process_byepass", type: "integer")]
    private int $processByepass;

    #[Column(name: "jc_bom_wastage", type: "integer")]
    private int $jcBomWastage;

    #[Column(name: "bom_1000", type: "integer")]
    private int $bom1000;

    #[Column(name: "batch_authorized_id", type: "string", nullable: true)]
    private ?string $batchAuthorizedId;

    #[Column(name: "tufting_plan_active", type: "integer", nullable: true)]
    private ?int $tuftingPlanActive;

    #[Column(name: "tufting_plan_sgrp", type: "string", nullable: true)]
    private ?string $tuftingPlanSgrp;

    #[Column(name: "tufting_plan_loom_group", type: "smallint", nullable: true)]
    private ?int $tuftingPlanLoomGroup;

    #[Column(name: "tufting_performance_percent", type: "decimal")]
    private string $tuftingPerformancePercent;

    #[Column(name: "jc_weeks", type: "smallint")]
    private int $jcWeeks;

    #[Column(name: "required_material_overall_update", type: "smallint")]
    private int $requiredMaterialOverallUpdate;

    #[Column(name: "jc_material_issue", type: "integer", nullable: true)]
    private ?int $jcMaterialIssue;

    #[Column(name: "jc_qr", type: "integer")]
    private int $jcQr;

    #[Column(name: "jc_mrlot", type: "string", nullable: true)]
    private ?string $jcMrlot;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "max_jobcard", type: "integer")]
    private int $maxJobcard;

    #[Column(name: "jc_pending_delete_days", type: "smallint")]
    private int $jcPendingDeleteDays;

    #[Column(name: "batch_pp_id", type: "smallint", nullable: true)]
    private ?int $batchPpId;

    public function __construct()
    {
        $this->csMinWidth = "0.00";
        $this->csMinQty = 1;
        $this->paymentSqm = "sqm";
        $this->paymentSqmByepassCategory = "0";
        $this->processByepass = 0;
        $this->jcBomWastage = 0;
        $this->bom1000 = 0;
        $this->batchAuthorizedId = "51";
        $this->tuftingPlanActive = 1;
        $this->tuftingPlanLoomGroup = 0;
        $this->requiredMaterialOverallUpdate = 1;
        $this->jcMaterialIssue = 0;
        $this->operator = 0;
        $this->maxJobcard = 2;
        $this->jcPendingDeleteDays = 5;
        $this->batchPpId = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getCsMinWidth(): ?string
    {
        return $this->csMinWidth;
    }

    public function setCsMinWidth(?string $value): static
    {
        $this->csMinWidth = $value;
        return $this;
    }

    public function getCsMinQty(): ?int
    {
        return $this->csMinQty;
    }

    public function setCsMinQty(?int $value): static
    {
        $this->csMinQty = $value;
        return $this;
    }

    public function getPaymentSqm(): string
    {
        return HtmlDecode($this->paymentSqm);
    }

    public function setPaymentSqm(string $value): static
    {
        $this->paymentSqm = RemoveXss($value);
        return $this;
    }

    public function getPaymentSqmByepassCategory(): string
    {
        return HtmlDecode($this->paymentSqmByepassCategory);
    }

    public function setPaymentSqmByepassCategory(string $value): static
    {
        $this->paymentSqmByepassCategory = RemoveXss($value);
        return $this;
    }

    public function getProcessByepass(): int
    {
        return $this->processByepass;
    }

    public function setProcessByepass(int $value): static
    {
        $this->processByepass = $value;
        return $this;
    }

    public function getJcBomWastage(): int
    {
        return $this->jcBomWastage;
    }

    public function setJcBomWastage(int $value): static
    {
        $this->jcBomWastage = $value;
        return $this;
    }

    public function getBom1000(): int
    {
        return $this->bom1000;
    }

    public function setBom1000(int $value): static
    {
        $this->bom1000 = $value;
        return $this;
    }

    public function getBatchAuthorizedId(): ?string
    {
        return HtmlDecode($this->batchAuthorizedId);
    }

    public function setBatchAuthorizedId(?string $value): static
    {
        $this->batchAuthorizedId = RemoveXss($value);
        return $this;
    }

    public function getTuftingPlanActive(): ?int
    {
        return $this->tuftingPlanActive;
    }

    public function setTuftingPlanActive(?int $value): static
    {
        $this->tuftingPlanActive = $value;
        return $this;
    }

    public function getTuftingPlanSgrp(): ?string
    {
        return HtmlDecode($this->tuftingPlanSgrp);
    }

    public function setTuftingPlanSgrp(?string $value): static
    {
        $this->tuftingPlanSgrp = RemoveXss($value);
        return $this;
    }

    public function getTuftingPlanLoomGroup(): ?int
    {
        return $this->tuftingPlanLoomGroup;
    }

    public function setTuftingPlanLoomGroup(?int $value): static
    {
        $this->tuftingPlanLoomGroup = $value;
        return $this;
    }

    public function getTuftingPerformancePercent(): string
    {
        return $this->tuftingPerformancePercent;
    }

    public function setTuftingPerformancePercent(string $value): static
    {
        $this->tuftingPerformancePercent = $value;
        return $this;
    }

    public function getJcWeeks(): int
    {
        return $this->jcWeeks;
    }

    public function setJcWeeks(int $value): static
    {
        $this->jcWeeks = $value;
        return $this;
    }

    public function getRequiredMaterialOverallUpdate(): int
    {
        return $this->requiredMaterialOverallUpdate;
    }

    public function setRequiredMaterialOverallUpdate(int $value): static
    {
        $this->requiredMaterialOverallUpdate = $value;
        return $this;
    }

    public function getJcMaterialIssue(): ?int
    {
        return $this->jcMaterialIssue;
    }

    public function setJcMaterialIssue(?int $value): static
    {
        $this->jcMaterialIssue = $value;
        return $this;
    }

    public function getJcQr(): int
    {
        return $this->jcQr;
    }

    public function setJcQr(int $value): static
    {
        $this->jcQr = $value;
        return $this;
    }

    public function getJcMrlot(): ?string
    {
        return HtmlDecode($this->jcMrlot);
    }

    public function setJcMrlot(?string $value): static
    {
        $this->jcMrlot = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getMaxJobcard(): int
    {
        return $this->maxJobcard;
    }

    public function setMaxJobcard(int $value): static
    {
        $this->maxJobcard = $value;
        return $this;
    }

    public function getJcPendingDeleteDays(): int
    {
        return $this->jcPendingDeleteDays;
    }

    public function setJcPendingDeleteDays(int $value): static
    {
        $this->jcPendingDeleteDays = $value;
        return $this;
    }

    public function getBatchPpId(): ?int
    {
        return $this->batchPpId;
    }

    public function setBatchPpId(?int $value): static
    {
        $this->batchPpId = $value;
        return $this;
    }
}
