<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "calendar_routine_task" table
 */
#[Entity]
#[Table(name: "calendar_routine_task")]
class CalendarRoutineTask extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string")]
    private string $title;

    #[Column(type: "datetime")]
    private DateTime $start;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $end;

    #[Column(type: "boolean")]
    private bool $allday;

    #[Column(type: "string", nullable: true)]
    private ?string $description;

    #[Column(type: "string", nullable: true)]
    private ?string $groupid;

    #[Column(type: "string", nullable: true)]
    private ?string $url;

    #[Column(type: "string", nullable: true)]
    private ?string $backgroundcolor;

    #[Column(type: "string", nullable: true)]
    private ?string $classnames;

    #[Column(type: "string", nullable: true)]
    private ?string $display;

    #[Column(type: "integer", nullable: true)]
    private ?int $cron;

    #[Column(name: "next_cycle", type: "datetime", nullable: true)]
    private ?DateTime $nextCycle;

    #[Column(type: "integer", nullable: true)]
    private ?int $delay;

    #[Column(name: "delay_method", type: "integer", nullable: true)]
    private ?int $delayMethod;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->backgroundcolor = 'red';
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getTitle(): string
    {
        return HtmlDecode($this->title);
    }

    public function setTitle(string $value): static
    {
        $this->title = RemoveXss($value);
        return $this;
    }

    public function getStart(): DateTime
    {
        return $this->start;
    }

    public function setStart(DateTime $value): static
    {
        $this->start = $value;
        return $this;
    }

    public function getEnd(): ?DateTime
    {
        return $this->end;
    }

    public function setEnd(?DateTime $value): static
    {
        $this->end = $value;
        return $this;
    }

    public function getAllday(): bool
    {
        return $this->allday;
    }

    public function setAllday(bool $value): static
    {
        $this->allday = $value;
        return $this;
    }

    public function getDescription(): ?string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(?string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getGroupid(): ?string
    {
        return HtmlDecode($this->groupid);
    }

    public function setGroupid(?string $value): static
    {
        $this->groupid = RemoveXss($value);
        return $this;
    }

    public function getUrl(): ?string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(?string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }

    public function getBackgroundcolor(): ?string
    {
        return HtmlDecode($this->backgroundcolor);
    }

    public function setBackgroundcolor(?string $value): static
    {
        $this->backgroundcolor = RemoveXss($value);
        return $this;
    }

    public function getClassnames(): ?string
    {
        return HtmlDecode($this->classnames);
    }

    public function setClassnames(?string $value): static
    {
        $this->classnames = RemoveXss($value);
        return $this;
    }

    public function getDisplay(): ?string
    {
        return HtmlDecode($this->display);
    }

    public function setDisplay(?string $value): static
    {
        $this->display = RemoveXss($value);
        return $this;
    }

    public function getCron(): ?int
    {
        return $this->cron;
    }

    public function setCron(?int $value): static
    {
        $this->cron = $value;
        return $this;
    }

    public function getNextCycle(): ?DateTime
    {
        return $this->nextCycle;
    }

    public function setNextCycle(?DateTime $value): static
    {
        $this->nextCycle = $value;
        return $this;
    }

    public function getDelay(): ?int
    {
        return $this->delay;
    }

    public function setDelay(?int $value): static
    {
        $this->delay = $value;
        return $this;
    }

    public function getDelayMethod(): ?int
    {
        return $this->delayMethod;
    }

    public function setDelayMethod(?int $value): static
    {
        $this->delayMethod = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
