<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "calendar_deleted" table
 */
#[Entity]
#[Table(name: "calendar_deleted")]
class CalendarDeleted extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string")]
    private string $title;

    #[Column(type: "datetime")]
    private DateTime $start;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $end;

    #[Column(type: "boolean", nullable: true)]
    private ?bool $allday;

    #[Column(type: "text", nullable: true)]
    private ?string $description;

    #[Column(type: "string", nullable: true)]
    private ?string $groupid;

    #[Column(type: "string", nullable: true)]
    private ?string $url;

    #[Column(type: "string", nullable: true)]
    private ?string $classnames;

    #[Column(type: "string", nullable: true)]
    private ?string $display;

    #[Column(type: "string", nullable: true)]
    private ?string $backgroundcolor;

    public function __construct()
    {
        $this->allday = false;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getTitle(): string
    {
        return HtmlDecode($this->title);
    }

    public function setTitle(string $value): static
    {
        $this->title = RemoveXss($value);
        return $this;
    }

    public function getStart(): DateTime
    {
        return $this->start;
    }

    public function setStart(DateTime $value): static
    {
        $this->start = $value;
        return $this;
    }

    public function getEnd(): ?DateTime
    {
        return $this->end;
    }

    public function setEnd(?DateTime $value): static
    {
        $this->end = $value;
        return $this;
    }

    public function getAllday(): ?bool
    {
        return $this->allday;
    }

    public function setAllday(?bool $value): static
    {
        $this->allday = $value;
        return $this;
    }

    public function getDescription(): ?string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(?string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getGroupid(): ?string
    {
        return HtmlDecode($this->groupid);
    }

    public function setGroupid(?string $value): static
    {
        $this->groupid = RemoveXss($value);
        return $this;
    }

    public function getUrl(): ?string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(?string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }

    public function getClassnames(): ?string
    {
        return HtmlDecode($this->classnames);
    }

    public function setClassnames(?string $value): static
    {
        $this->classnames = RemoveXss($value);
        return $this;
    }

    public function getDisplay(): ?string
    {
        return HtmlDecode($this->display);
    }

    public function setDisplay(?string $value): static
    {
        $this->display = RemoveXss($value);
        return $this;
    }

    public function getBackgroundcolor(): ?string
    {
        return HtmlDecode($this->backgroundcolor);
    }

    public function setBackgroundcolor(?string $value): static
    {
        $this->backgroundcolor = RemoveXss($value);
        return $this;
    }
}
