<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "byproduct_comparison" table
 */
#[Entity]
#[Table(name: "byproduct_comparison")]
class ByproductComparison extends AbstractEntity
{
    #[Column(name: "s_grp", type: "smallint")]
    private int $sGrp;

    #[Column(type: "smallint")]
    private int $rid;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(name: "lot_no", type: "string")]
    private string $lotNo;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "decimal", nullable: true)]
    private ?string $base;

    #[Column(type: "decimal", nullable: true)]
    private ?string $n1;

    #[Column(type: "decimal", nullable: true)]
    private ?string $n2;

    #[Column(type: "decimal", nullable: true)]
    private ?string $n3;

    #[Column(type: "decimal", nullable: true)]
    private ?string $n4;

    #[Column(name: "processed_by", type: "integer", nullable: true)]
    private ?int $processedBy;

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getRid(): int
    {
        return $this->rid;
    }

    public function setRid(int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getLotNo(): string
    {
        return HtmlDecode($this->lotNo);
    }

    public function setLotNo(string $value): static
    {
        $this->lotNo = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getBase(): ?string
    {
        return $this->base;
    }

    public function setBase(?string $value): static
    {
        $this->base = $value;
        return $this;
    }

    public function getN1(): ?string
    {
        return $this->n1;
    }

    public function setN1(?string $value): static
    {
        $this->n1 = $value;
        return $this;
    }

    public function getN2(): ?string
    {
        return $this->n2;
    }

    public function setN2(?string $value): static
    {
        $this->n2 = $value;
        return $this;
    }

    public function getN3(): ?string
    {
        return $this->n3;
    }

    public function setN3(?string $value): static
    {
        $this->n3 = $value;
        return $this;
    }

    public function getN4(): ?string
    {
        return $this->n4;
    }

    public function setN4(?string $value): static
    {
        $this->n4 = $value;
        return $this;
    }

    public function getProcessedBy(): ?int
    {
        return $this->processedBy;
    }

    public function setProcessedBy(?int $value): static
    {
        $this->processedBy = $value;
        return $this;
    }
}
