<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "buyer_seller_view" table
 */
#[Entity]
#[Table(name: "buyer_seller_view")]
class BuyerSellerView extends AbstractEntity
{
    #[Column(type: "integer")]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $name;

    #[Column(type: "decimal", nullable: true)]
    private ?string $status;

    #[Column(name: "partner_type", type: "string")]
    private string $partnerType;

    #[Column(type: "text", nullable: true)]
    private ?string $address;

    #[Column(type: "string")]
    private string $merchant;

    #[Column(type: "integer")]
    private int $category;

    #[Column(type: "string", nullable: true)]
    private ?string $currency;

    #[Column(name: "mo_type", type: "string")]
    private string $moType;

    #[Column(type: "string", nullable: true)]
    private ?string $mobile;

    #[Column(type: "string", nullable: true)]
    private ?string $code;

    #[Column(type: "string", nullable: true)]
    private ?string $city;

    public function __construct()
    {
        $this->id = 0;
        $this->status = "0";
        $this->category = 0;
        $this->moType = "0";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getName(): ?string
    {
        return HtmlDecode($this->name);
    }

    public function setName(?string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?string
    {
        return $this->status;
    }

    public function setStatus(?string $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getPartnerType(): string
    {
        return HtmlDecode($this->partnerType);
    }

    public function setPartnerType(string $value): static
    {
        $this->partnerType = RemoveXss($value);
        return $this;
    }

    public function getAddress(): ?string
    {
        return HtmlDecode($this->address);
    }

    public function setAddress(?string $value): static
    {
        $this->address = RemoveXss($value);
        return $this;
    }

    public function getMerchant(): string
    {
        return HtmlDecode($this->merchant);
    }

    public function setMerchant(string $value): static
    {
        $this->merchant = RemoveXss($value);
        return $this;
    }

    public function getCategory(): int
    {
        return $this->category;
    }

    public function setCategory(int $value): static
    {
        $this->category = $value;
        return $this;
    }

    public function getCurrency(): ?string
    {
        return HtmlDecode($this->currency);
    }

    public function setCurrency(?string $value): static
    {
        $this->currency = RemoveXss($value);
        return $this;
    }

    public function getMoType(): string
    {
        return HtmlDecode($this->moType);
    }

    public function setMoType(string $value): static
    {
        $this->moType = RemoveXss($value);
        return $this;
    }

    public function getMobile(): ?string
    {
        return HtmlDecode($this->mobile);
    }

    public function setMobile(?string $value): static
    {
        $this->mobile = RemoveXss($value);
        return $this;
    }

    public function getCode(): ?string
    {
        return HtmlDecode($this->code);
    }

    public function setCode(?string $value): static
    {
        $this->code = RemoveXss($value);
        return $this;
    }

    public function getCity(): ?string
    {
        return HtmlDecode($this->city);
    }

    public function setCity(?string $value): static
    {
        $this->city = RemoveXss($value);
        return $this;
    }
}
