<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "buyer_product_ref_g" table
 */
#[Entity]
#[Table(name: "buyer_product_ref_g")]
class BuyerProductRefG extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "integer")]
    private int $partner;

    #[Column(name: "partner_ref", type: "string")]
    private string $partnerRef;

    #[Column(type: "string", nullable: true)]
    private ?string $barcode;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(type: "smallint", nullable: true)]
    private ?int $product;

    #[Column(type: "smallint", nullable: true)]
    private ?int $rid;

    #[Column(type: "float", nullable: true)]
    private ?float $price;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "string")]
    private string $gcode;

    #[Column(name: "batch_no", type: "smallint", nullable: true)]
    private ?int $batchNo;

    #[Column(name: "w_cm", type: "integer", nullable: true)]
    private ?int $wCm;

    #[Column(name: "l_cm", type: "integer", nullable: true)]
    private ?int $lCm;

    #[Column(type: "string", nullable: true)]
    private ?string $shape;

    #[Column(type: "smallint", nullable: true)]
    private ?int $currency;

    public function __construct()
    {
        $this->grp = 3;
        $this->status = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPartner(): int
    {
        return $this->partner;
    }

    public function setPartner(int $value): static
    {
        $this->partner = $value;
        return $this;
    }

    public function getPartnerRef(): string
    {
        return HtmlDecode($this->partnerRef);
    }

    public function setPartnerRef(string $value): static
    {
        $this->partnerRef = RemoveXss($value);
        return $this;
    }

    public function getBarcode(): ?string
    {
        return HtmlDecode($this->barcode);
    }

    public function setBarcode(?string $value): static
    {
        $this->barcode = RemoveXss($value);
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): ?int
    {
        return $this->product;
    }

    public function setProduct(?int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRid(): ?int
    {
        return $this->rid;
    }

    public function setRid(?int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getPrice(): ?float
    {
        return $this->price;
    }

    public function setPrice(?float $value): static
    {
        $this->price = $value;
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getGcode(): string
    {
        return HtmlDecode($this->gcode);
    }

    public function setGcode(string $value): static
    {
        $this->gcode = RemoveXss($value);
        return $this;
    }

    public function getBatchNo(): ?int
    {
        return $this->batchNo;
    }

    public function setBatchNo(?int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getWCm(): ?int
    {
        return $this->wCm;
    }

    public function setWCm(?int $value): static
    {
        $this->wCm = $value;
        return $this;
    }

    public function getLCm(): ?int
    {
        return $this->lCm;
    }

    public function setLCm(?int $value): static
    {
        $this->lCm = $value;
        return $this;
    }

    public function getShape(): ?string
    {
        return HtmlDecode($this->shape);
    }

    public function setShape(?string $value): static
    {
        $this->shape = RemoveXss($value);
        return $this;
    }

    public function getCurrency(): ?int
    {
        return $this->currency;
    }

    public function setCurrency(?int $value): static
    {
        $this->currency = $value;
        return $this;
    }
}
