<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "buyer" table
 */
#[Entity]
#[Table(name: "buyer")]
class Buyer extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "user_name", type: "string", nullable: true)]
    private ?string $userName;

    #[Column(type: "string", nullable: true)]
    private ?string $password;

    #[Column(type: "smallint")]
    private int $category;

    #[Column(name: "sub_category", type: "smallint", nullable: true)]
    private ?int $subCategory;

    #[Column(type: "string", nullable: true)]
    private ?string $grp;

    #[Column(type: "string")]
    private string $name;

    #[Column(type: "string", nullable: true)]
    private ?string $code;

    #[Column(type: "integer", nullable: true)]
    private ?int $seller;

    #[Column(type: "string", nullable: true)]
    private ?string $mobile;

    #[Column(type: "string", nullable: true)]
    private ?string $email;

    #[Column(type: "smallint", nullable: true)]
    private ?int $country;

    #[Column(type: "integer", nullable: true)]
    private ?int $region;

    #[Column(type: "bigint", nullable: true)]
    private ?string $city;

    #[Column(name: "city_name", type: "string", nullable: true)]
    private ?string $cityName;

    #[Column(type: "string", nullable: true)]
    private ?string $address;

    #[Column(type: "string", nullable: true)]
    private ?string $location;

    #[Column(name: "reports_to", type: "string")]
    private string $reportsTo;

    #[Column(type: "integer")]
    private int $status;

    #[Column(name: "tax_registration", type: "string", nullable: true)]
    private ?string $taxRegistration;

    #[Column(type: "smallint", nullable: true)]
    private ?int $currency;

    #[Column(name: "port_sea", type: "smallint", nullable: true)]
    private ?int $portSea;

    #[Column(type: "string", nullable: true)]
    private ?string $incoterm;

    #[Column(name: "port_air", type: "smallint", nullable: true)]
    private ?int $portAir;

    #[Column(type: "string", nullable: true)]
    private ?string $type;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "string", unique: true)]
    private string $uid;

    #[Column(type: "integer", nullable: true)]
    private ?int $performance;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "price_percent", type: "float", nullable: true)]
    private ?float $pricePercent;

    #[Column(name: "last_login", type: "datetime", nullable: true)]
    private ?DateTime $lastLogin;

    #[Column(name: "reg_date", type: "datetime", nullable: true)]
    private ?DateTime $regDate;

    #[Column(name: "reg_device", type: "smallint", nullable: true)]
    private ?int $regDevice;

    #[Column(name: "device_id", type: "string", nullable: true)]
    private ?string $deviceId;

    #[Column(name: "device_token_id", type: "string", nullable: true)]
    private ?string $deviceTokenId;

    #[Column(name: "cart_number", type: "integer", nullable: true)]
    private ?int $cartNumber;

    #[Column(name: "r_text", type: "string", nullable: true)]
    private ?string $rText;

    public function __construct()
    {
        $this->seller = 200000;
        $this->country = 96;
        $this->status = 1;
        $this->operator = 0;
        $this->uid = "1";
        $this->performance = 100;
        $this->pricePercent = 100;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getUserName(): ?string
    {
        return HtmlDecode($this->userName);
    }

    public function setUserName(?string $value): static
    {
        $this->userName = RemoveXss($value);
        return $this;
    }

    public function getPassword(): ?string
    {
        return HtmlDecode($this->password);
    }

    public function setPassword(?string $value): static
    {
        $this->password = RemoveXss($value);
        return $this;
    }

    public function getCategory(): int
    {
        return $this->category;
    }

    public function setCategory(int $value): static
    {
        $this->category = $value;
        return $this;
    }

    public function getSubCategory(): ?int
    {
        return $this->subCategory;
    }

    public function setSubCategory(?int $value): static
    {
        $this->subCategory = $value;
        return $this;
    }

    public function getGrp(): ?string
    {
        return HtmlDecode($this->grp);
    }

    public function setGrp(?string $value): static
    {
        $this->grp = RemoveXss($value);
        return $this;
    }

    public function getName(): string
    {
        return HtmlDecode($this->name);
    }

    public function setName(string $value): static
    {
        $this->name = RemoveXss($value);
        return $this;
    }

    public function getCode(): ?string
    {
        return HtmlDecode($this->code);
    }

    public function setCode(?string $value): static
    {
        $this->code = RemoveXss($value);
        return $this;
    }

    public function getSeller(): ?int
    {
        return $this->seller;
    }

    public function setSeller(?int $value): static
    {
        $this->seller = $value;
        return $this;
    }

    public function getMobile(): ?string
    {
        return HtmlDecode($this->mobile);
    }

    public function setMobile(?string $value): static
    {
        $this->mobile = RemoveXss($value);
        return $this;
    }

    public function getEmail(): ?string
    {
        return HtmlDecode($this->email);
    }

    public function setEmail(?string $value): static
    {
        $this->email = RemoveXss($value);
        return $this;
    }

    public function getCountry(): ?int
    {
        return $this->country;
    }

    public function setCountry(?int $value): static
    {
        $this->country = $value;
        return $this;
    }

    public function getRegion(): ?int
    {
        return $this->region;
    }

    public function setRegion(?int $value): static
    {
        $this->region = $value;
        return $this;
    }

    public function getCity(): ?string
    {
        return $this->city;
    }

    public function setCity(?string $value): static
    {
        $this->city = $value;
        return $this;
    }

    public function getCityName(): ?string
    {
        return HtmlDecode($this->cityName);
    }

    public function setCityName(?string $value): static
    {
        $this->cityName = RemoveXss($value);
        return $this;
    }

    public function getAddress(): ?string
    {
        return HtmlDecode($this->address);
    }

    public function setAddress(?string $value): static
    {
        $this->address = RemoveXss($value);
        return $this;
    }

    public function getLocation(): ?string
    {
        return HtmlDecode($this->location);
    }

    public function setLocation(?string $value): static
    {
        $this->location = RemoveXss($value);
        return $this;
    }

    public function getReportsTo(): string
    {
        return HtmlDecode($this->reportsTo);
    }

    public function setReportsTo(string $value): static
    {
        $this->reportsTo = RemoveXss($value);
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getTaxRegistration(): ?string
    {
        return HtmlDecode($this->taxRegistration);
    }

    public function setTaxRegistration(?string $value): static
    {
        $this->taxRegistration = RemoveXss($value);
        return $this;
    }

    public function getCurrency(): ?int
    {
        return $this->currency;
    }

    public function setCurrency(?int $value): static
    {
        $this->currency = $value;
        return $this;
    }

    public function getPortSea(): ?int
    {
        return $this->portSea;
    }

    public function setPortSea(?int $value): static
    {
        $this->portSea = $value;
        return $this;
    }

    public function getIncoterm(): ?string
    {
        return HtmlDecode($this->incoterm);
    }

    public function setIncoterm(?string $value): static
    {
        $this->incoterm = RemoveXss($value);
        return $this;
    }

    public function getPortAir(): ?int
    {
        return $this->portAir;
    }

    public function setPortAir(?int $value): static
    {
        $this->portAir = $value;
        return $this;
    }

    public function getType(): ?string
    {
        return HtmlDecode($this->type);
    }

    public function setType(?string $value): static
    {
        $this->type = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getUid(): string
    {
        return HtmlDecode($this->uid);
    }

    public function setUid(string $value): static
    {
        $this->uid = RemoveXss($value);
        return $this;
    }

    public function getPerformance(): ?int
    {
        return $this->performance;
    }

    public function setPerformance(?int $value): static
    {
        $this->performance = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getPricePercent(): ?float
    {
        return $this->pricePercent;
    }

    public function setPricePercent(?float $value): static
    {
        $this->pricePercent = $value;
        return $this;
    }

    public function getLastLogin(): ?DateTime
    {
        return $this->lastLogin;
    }

    public function setLastLogin(?DateTime $value): static
    {
        $this->lastLogin = $value;
        return $this;
    }

    public function getRegDate(): ?DateTime
    {
        return $this->regDate;
    }

    public function setRegDate(?DateTime $value): static
    {
        $this->regDate = $value;
        return $this;
    }

    public function getRegDevice(): ?int
    {
        return $this->regDevice;
    }

    public function setRegDevice(?int $value): static
    {
        $this->regDevice = $value;
        return $this;
    }

    public function getDeviceId(): ?string
    {
        return HtmlDecode($this->deviceId);
    }

    public function setDeviceId(?string $value): static
    {
        $this->deviceId = RemoveXss($value);
        return $this;
    }

    public function getDeviceTokenId(): ?string
    {
        return HtmlDecode($this->deviceTokenId);
    }

    public function setDeviceTokenId(?string $value): static
    {
        $this->deviceTokenId = RemoveXss($value);
        return $this;
    }

    public function getCartNumber(): ?int
    {
        return $this->cartNumber;
    }

    public function setCartNumber(?int $value): static
    {
        $this->cartNumber = $value;
        return $this;
    }

    public function getRText(): ?string
    {
        return HtmlDecode($this->rText);
    }

    public function setRText(?string $value): static
    {
        $this->rText = RemoveXss($value);
        return $this;
    }
}
