<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "booking_ref" table
 */
#[Entity]
#[Table(name: "booking_ref")]
class BookingRef extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint")]
    private int $id;

    #[Column(name: "supplier_id", type: "integer", nullable: true)]
    private ?int $supplierId;

    #[Column(type: "string")]
    private string $ref;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $rid;

    #[Column(type: "decimal", nullable: true)]
    private ?string $quantity;

    #[Column(name: "b_quantity", type: "decimal", nullable: true)]
    private ?string $bQuantity;

    #[Column(name: "confirm_quantity", type: "decimal")]
    private string $confirmQuantity;

    #[Column(name: "confirm_pending", type: "decimal", nullable: true)]
    private ?string $confirmPending;

    #[Column(type: "decimal", nullable: true)]
    private ?string $containers;

    #[Column(name: "booking_date", type: "datetime", nullable: true)]
    private ?DateTime $bookingDate;

    #[Column(name: "booking_rate", type: "decimal", nullable: true)]
    private ?string $bookingRate;

    #[Column(name: "booking_currency", type: "integer", nullable: true)]
    private ?int $bookingCurrency;

    #[Column(type: "decimal", nullable: true)]
    private ?string $amount;

    #[Column(type: "text", nullable: true)]
    private ?string $currency;

    #[Column(name: "confirm_port_eta", type: "text", nullable: true)]
    private ?string $confirmPortEta;

    #[Column(type: "text", nullable: true)]
    private ?string $reference;

    #[Column(name: "currency_current_rate", type: "decimal", nullable: true)]
    private ?string $currencyCurrentRate;

    #[Column(name: "shipment_date", type: "datetime", nullable: true)]
    private ?DateTime $shipmentDate;

    #[Column(name: "our_port", type: "integer", nullable: true)]
    private ?int $ourPort;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "string")]
    private string $url;

    #[Column(name: "product_code", type: "string", nullable: true)]
    private ?string $productCode;

    #[Column(type: "smallint", nullable: true)]
    private ?int $packets;

    #[Column(name: "confirm_type", type: "string", nullable: true)]
    private ?string $confirmType;

    #[Column(name: "company_id", type: "integer")]
    private int $companyId;

    public function __construct()
    {
        $this->status = 0;
        $this->confirmQuantity = "0.000";
        $this->operator = 0;
        $this->confirmType = "1";
        $this->companyId = 200000;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getSupplierId(): ?int
    {
        return $this->supplierId;
    }

    public function setSupplierId(?int $value): static
    {
        $this->supplierId = $value;
        return $this;
    }

    public function getRef(): string
    {
        return HtmlDecode($this->ref);
    }

    public function setRef(string $value): static
    {
        $this->ref = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getRid(): ?int
    {
        return $this->rid;
    }

    public function setRid(?int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getQuantity(): ?string
    {
        return $this->quantity;
    }

    public function setQuantity(?string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getBQuantity(): ?string
    {
        return $this->bQuantity;
    }

    public function setBQuantity(?string $value): static
    {
        $this->bQuantity = $value;
        return $this;
    }

    public function getConfirmQuantity(): string
    {
        return $this->confirmQuantity;
    }

    public function setConfirmQuantity(string $value): static
    {
        $this->confirmQuantity = $value;
        return $this;
    }

    public function getConfirmPending(): ?string
    {
        return $this->confirmPending;
    }

    public function setConfirmPending(?string $value): static
    {
        $this->confirmPending = $value;
        return $this;
    }

    public function getContainers(): ?string
    {
        return $this->containers;
    }

    public function setContainers(?string $value): static
    {
        $this->containers = $value;
        return $this;
    }

    public function getBookingDate(): ?DateTime
    {
        return $this->bookingDate;
    }

    public function setBookingDate(?DateTime $value): static
    {
        $this->bookingDate = $value;
        return $this;
    }

    public function getBookingRate(): ?string
    {
        return $this->bookingRate;
    }

    public function setBookingRate(?string $value): static
    {
        $this->bookingRate = $value;
        return $this;
    }

    public function getBookingCurrency(): ?int
    {
        return $this->bookingCurrency;
    }

    public function setBookingCurrency(?int $value): static
    {
        $this->bookingCurrency = $value;
        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getCurrency(): ?string
    {
        return HtmlDecode($this->currency);
    }

    public function setCurrency(?string $value): static
    {
        $this->currency = RemoveXss($value);
        return $this;
    }

    public function getConfirmPortEta(): ?string
    {
        return HtmlDecode($this->confirmPortEta);
    }

    public function setConfirmPortEta(?string $value): static
    {
        $this->confirmPortEta = RemoveXss($value);
        return $this;
    }

    public function getReference(): ?string
    {
        return HtmlDecode($this->reference);
    }

    public function setReference(?string $value): static
    {
        $this->reference = RemoveXss($value);
        return $this;
    }

    public function getCurrencyCurrentRate(): ?string
    {
        return $this->currencyCurrentRate;
    }

    public function setCurrencyCurrentRate(?string $value): static
    {
        $this->currencyCurrentRate = $value;
        return $this;
    }

    public function getShipmentDate(): ?DateTime
    {
        return $this->shipmentDate;
    }

    public function setShipmentDate(?DateTime $value): static
    {
        $this->shipmentDate = $value;
        return $this;
    }

    public function getOurPort(): ?int
    {
        return $this->ourPort;
    }

    public function setOurPort(?int $value): static
    {
        $this->ourPort = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getUrl(): string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getPackets(): ?int
    {
        return $this->packets;
    }

    public function setPackets(?int $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getConfirmType(): ?string
    {
        return HtmlDecode($this->confirmType);
    }

    public function setConfirmType(?string $value): static
    {
        $this->confirmType = RemoveXss($value);
        return $this;
    }

    public function getCompanyId(): int
    {
        return $this->companyId;
    }

    public function setCompanyId(int $value): static
    {
        $this->companyId = $value;
        return $this;
    }
}
