<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "booking_details" table
 */
#[Entity]
#[Table(name: "booking_details")]
class BookingDetail extends AbstractEntity
{
    #[Column(type: "text", nullable: true)]
    private ?string $id;

    #[Column(type: "string")]
    private string $ref;

    #[Column(type: "integer", nullable: true)]
    private ?int $agent;

    #[Column(name: "product_code", type: "text", nullable: true)]
    private ?string $productCode;

    #[Column(type: "integer", nullable: true)]
    private ?int $supplier;

    #[Column(type: "decimal", nullable: true)]
    private ?string $quantity;

    #[Column(name: "b_quantity", type: "decimal")]
    private string $bQuantity;

    #[Column(name: "confirm_quantity", type: "decimal")]
    private string $confirmQuantity;

    #[Column(name: "port_eta", type: "text", nullable: true)]
    private ?string $portEta;

    #[Column(name: "bl_no", type: "text", nullable: true)]
    private ?string $blNo;

    #[Column(type: "decimal", nullable: true)]
    private ?string $containers;

    #[Column(name: "booking_currency", type: "integer", nullable: true)]
    private ?int $bookingCurrency;

    #[Column(type: "decimal", nullable: true)]
    private ?string $amount;

    #[Column(type: "decimal")]
    private string $paid;

    #[Column(type: "decimal", nullable: true)]
    private ?string $balance;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(name: "booking_by", type: "smallint", nullable: true)]
    private ?int $bookingBy;

    #[Column(name: "company_id", type: "integer")]
    private int $companyId;

    #[Column(name: "t_url", type: "text", nullable: true)]
    private ?string $tUrl;

    public function __construct()
    {
        $this->bQuantity = "0.000";
        $this->confirmQuantity = "0.000";
        $this->paid = "0.00";
        $this->status = 0;
        $this->companyId = 200000;
    }

    public function getId(): ?string
    {
        return HtmlDecode($this->id);
    }

    public function setId(?string $value): static
    {
        $this->id = RemoveXss($value);
        return $this;
    }

    public function getRef(): string
    {
        return HtmlDecode($this->ref);
    }

    public function setRef(string $value): static
    {
        $this->ref = RemoveXss($value);
        return $this;
    }

    public function getAgent(): ?int
    {
        return $this->agent;
    }

    public function setAgent(?int $value): static
    {
        $this->agent = $value;
        return $this;
    }

    public function getProductCode(): ?string
    {
        return HtmlDecode($this->productCode);
    }

    public function setProductCode(?string $value): static
    {
        $this->productCode = RemoveXss($value);
        return $this;
    }

    public function getSupplier(): ?int
    {
        return $this->supplier;
    }

    public function setSupplier(?int $value): static
    {
        $this->supplier = $value;
        return $this;
    }

    public function getQuantity(): ?string
    {
        return $this->quantity;
    }

    public function setQuantity(?string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getBQuantity(): string
    {
        return $this->bQuantity;
    }

    public function setBQuantity(string $value): static
    {
        $this->bQuantity = $value;
        return $this;
    }

    public function getConfirmQuantity(): string
    {
        return $this->confirmQuantity;
    }

    public function setConfirmQuantity(string $value): static
    {
        $this->confirmQuantity = $value;
        return $this;
    }

    public function getPortEta(): ?string
    {
        return HtmlDecode($this->portEta);
    }

    public function setPortEta(?string $value): static
    {
        $this->portEta = RemoveXss($value);
        return $this;
    }

    public function getBlNo(): ?string
    {
        return HtmlDecode($this->blNo);
    }

    public function setBlNo(?string $value): static
    {
        $this->blNo = RemoveXss($value);
        return $this;
    }

    public function getContainers(): ?string
    {
        return $this->containers;
    }

    public function setContainers(?string $value): static
    {
        $this->containers = $value;
        return $this;
    }

    public function getBookingCurrency(): ?int
    {
        return $this->bookingCurrency;
    }

    public function setBookingCurrency(?int $value): static
    {
        $this->bookingCurrency = $value;
        return $this;
    }

    public function getAmount(): ?string
    {
        return $this->amount;
    }

    public function setAmount(?string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getPaid(): string
    {
        return $this->paid;
    }

    public function setPaid(string $value): static
    {
        $this->paid = $value;
        return $this;
    }

    public function getBalance(): ?string
    {
        return $this->balance;
    }

    public function setBalance(?string $value): static
    {
        $this->balance = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getBookingBy(): ?int
    {
        return $this->bookingBy;
    }

    public function setBookingBy(?int $value): static
    {
        $this->bookingBy = $value;
        return $this;
    }

    public function getCompanyId(): int
    {
        return $this->companyId;
    }

    public function setCompanyId(int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getTUrl(): ?string
    {
        return HtmlDecode($this->tUrl);
    }

    public function setTUrl(?string $value): static
    {
        $this->tUrl = RemoveXss($value);
        return $this;
    }
}
