<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "booking_confirm" table
 */
#[Entity]
#[Table(name: "booking_confirm")]
class BookingConfirm extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "integer", nullable: true)]
    private ?int $supplier;

    #[Column(name: "confirm_type", type: "string", nullable: true)]
    private ?string $confirmType;

    #[Column(name: "booking_ref", type: "smallint")]
    private int $bookingRef;

    #[Column(name: "approx_qty", type: "decimal", nullable: true)]
    private ?string $approxQty;

    #[Column(type: "smallint", nullable: true)]
    private ?int $packets;

    #[Column(type: "decimal")]
    private string $amount;

    #[Column(type: "smallint", nullable: true)]
    private ?int $currency;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $date;

    #[Column(type: "string", nullable: true)]
    private ?string $reference;

    #[Column(name: "date_of_dispatch", type: "date", nullable: true)]
    private ?DateTime $dateOfDispatch;

    #[Column(name: "port_eta", type: "date", nullable: true)]
    private ?DateTime $portEta;

    #[Column(name: "bl_no", type: "string", nullable: true)]
    private ?string $blNo;

    #[Column(name: "s_line", type: "smallint", nullable: true)]
    private ?int $sLine;

    #[Column(name: "company_id", type: "integer")]
    private int $companyId;

    #[Column(type: "smallint")]
    private int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(type: "string", nullable: true)]
    private ?string $fibc;

    #[Column(type: "string", nullable: true)]
    private ?string $ref;

    public function __construct()
    {
        $this->confirmType = "1";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getSupplier(): ?int
    {
        return $this->supplier;
    }

    public function setSupplier(?int $value): static
    {
        $this->supplier = $value;
        return $this;
    }

    public function getConfirmType(): ?string
    {
        return HtmlDecode($this->confirmType);
    }

    public function setConfirmType(?string $value): static
    {
        $this->confirmType = RemoveXss($value);
        return $this;
    }

    public function getBookingRef(): int
    {
        return $this->bookingRef;
    }

    public function setBookingRef(int $value): static
    {
        $this->bookingRef = $value;
        return $this;
    }

    public function getApproxQty(): ?string
    {
        return $this->approxQty;
    }

    public function setApproxQty(?string $value): static
    {
        $this->approxQty = $value;
        return $this;
    }

    public function getPackets(): ?int
    {
        return $this->packets;
    }

    public function setPackets(?int $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getAmount(): string
    {
        return $this->amount;
    }

    public function setAmount(string $value): static
    {
        $this->amount = $value;
        return $this;
    }

    public function getCurrency(): ?int
    {
        return $this->currency;
    }

    public function setCurrency(?int $value): static
    {
        $this->currency = $value;
        return $this;
    }

    public function getDate(): ?DateTime
    {
        return $this->date;
    }

    public function setDate(?DateTime $value): static
    {
        $this->date = $value;
        return $this;
    }

    public function getReference(): ?string
    {
        return HtmlDecode($this->reference);
    }

    public function setReference(?string $value): static
    {
        $this->reference = RemoveXss($value);
        return $this;
    }

    public function getDateOfDispatch(): ?DateTime
    {
        return $this->dateOfDispatch;
    }

    public function setDateOfDispatch(?DateTime $value): static
    {
        $this->dateOfDispatch = $value;
        return $this;
    }

    public function getPortEta(): ?DateTime
    {
        return $this->portEta;
    }

    public function setPortEta(?DateTime $value): static
    {
        $this->portEta = $value;
        return $this;
    }

    public function getBlNo(): ?string
    {
        return HtmlDecode($this->blNo);
    }

    public function setBlNo(?string $value): static
    {
        $this->blNo = RemoveXss($value);
        return $this;
    }

    public function getSLine(): ?int
    {
        return $this->sLine;
    }

    public function setSLine(?int $value): static
    {
        $this->sLine = $value;
        return $this;
    }

    public function getCompanyId(): int
    {
        return $this->companyId;
    }

    public function setCompanyId(int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getOperator(): int
    {
        return $this->operator;
    }

    public function setOperator(int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getFibc(): ?string
    {
        return HtmlDecode($this->fibc);
    }

    public function setFibc(?string $value): static
    {
        $this->fibc = RemoveXss($value);
        return $this;
    }

    public function getRef(): ?string
    {
        return HtmlDecode($this->ref);
    }

    public function setRef(?string $value): static
    {
        $this->ref = RemoveXss($value);
        return $this;
    }
}
