<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "booking" table
 */
#[Entity]
#[Table(name: "booking")]
class Booking extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "booking_by", type: "smallint", nullable: true)]
    private ?int $bookingBy;

    #[Column(name: "company_id", type: "integer")]
    private int $companyId;

    #[Column(type: "integer", nullable: true)]
    private ?int $supplier;

    #[Column(type: "string")]
    private string $ref;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "smallint")]
    private int $sGrp;

    #[Column(type: "smallint")]
    private int $product;

    #[Column(type: "smallint")]
    private int $rid;

    #[Column(type: "integer", nullable: true)]
    private ?int $agent;

    #[Column(type: "decimal", nullable: true)]
    private ?string $quantity;

    #[Column(name: "b_quantity", type: "decimal", nullable: true)]
    private ?string $bQuantity;

    #[Column(name: "confirm_quantity", type: "decimal")]
    private string $confirmQuantity;

    #[Column(type: "decimal", nullable: true)]
    private ?string $containers;

    #[Column(name: "booking_rate", type: "decimal", nullable: true)]
    private ?string $bookingRate;

    #[Column(name: "booking_currency", type: "integer", nullable: true)]
    private ?int $bookingCurrency;

    #[Column(name: "currency_current_rate", type: "decimal", nullable: true)]
    private ?string $currencyCurrentRate;

    #[Column(name: "booking_date", type: "datetime", nullable: true)]
    private ?DateTime $bookingDate;

    #[Column(name: "shipment_date", type: "datetime", nullable: true)]
    private ?DateTime $shipmentDate;

    #[Column(name: "our_port", type: "integer", nullable: true)]
    private ?int $ourPort;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "base_entry", type: "smallint", nullable: true)]
    private ?int $baseEntry;

    public function __construct()
    {
        $this->companyId = 200000;
        $this->status = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getBookingBy(): ?int
    {
        return $this->bookingBy;
    }

    public function setBookingBy(?int $value): static
    {
        $this->bookingBy = $value;
        return $this;
    }

    public function getCompanyId(): int
    {
        return $this->companyId;
    }

    public function setCompanyId(int $value): static
    {
        $this->companyId = $value;
        return $this;
    }

    public function getSupplier(): ?int
    {
        return $this->supplier;
    }

    public function setSupplier(?int $value): static
    {
        $this->supplier = $value;
        return $this;
    }

    public function getRef(): string
    {
        return HtmlDecode($this->ref);
    }

    public function setRef(string $value): static
    {
        $this->ref = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): int
    {
        return $this->product;
    }

    public function setProduct(int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRid(): int
    {
        return $this->rid;
    }

    public function setRid(int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getAgent(): ?int
    {
        return $this->agent;
    }

    public function setAgent(?int $value): static
    {
        $this->agent = $value;
        return $this;
    }

    public function getQuantity(): ?string
    {
        return $this->quantity;
    }

    public function setQuantity(?string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getBQuantity(): ?string
    {
        return $this->bQuantity;
    }

    public function setBQuantity(?string $value): static
    {
        $this->bQuantity = $value;
        return $this;
    }

    public function getConfirmQuantity(): string
    {
        return $this->confirmQuantity;
    }

    public function setConfirmQuantity(string $value): static
    {
        $this->confirmQuantity = $value;
        return $this;
    }

    public function getContainers(): ?string
    {
        return $this->containers;
    }

    public function setContainers(?string $value): static
    {
        $this->containers = $value;
        return $this;
    }

    public function getBookingRate(): ?string
    {
        return $this->bookingRate;
    }

    public function setBookingRate(?string $value): static
    {
        $this->bookingRate = $value;
        return $this;
    }

    public function getBookingCurrency(): ?int
    {
        return $this->bookingCurrency;
    }

    public function setBookingCurrency(?int $value): static
    {
        $this->bookingCurrency = $value;
        return $this;
    }

    public function getCurrencyCurrentRate(): ?string
    {
        return $this->currencyCurrentRate;
    }

    public function setCurrencyCurrentRate(?string $value): static
    {
        $this->currencyCurrentRate = $value;
        return $this;
    }

    public function getBookingDate(): ?DateTime
    {
        return $this->bookingDate;
    }

    public function setBookingDate(?DateTime $value): static
    {
        $this->bookingDate = $value;
        return $this;
    }

    public function getShipmentDate(): ?DateTime
    {
        return $this->shipmentDate;
    }

    public function setShipmentDate(?DateTime $value): static
    {
        $this->shipmentDate = $value;
        return $this;
    }

    public function getOurPort(): ?int
    {
        return $this->ourPort;
    }

    public function setOurPort(?int $value): static
    {
        $this->ourPort = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getBaseEntry(): ?int
    {
        return $this->baseEntry;
    }

    public function setBaseEntry(?int $value): static
    {
        $this->baseEntry = $value;
        return $this;
    }
}
