<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "bom" table
 */
#[Entity]
#[Table(name: "bom")]
class Bom extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(name: "warp_weft", type: "integer")]
    private int $warpWeft;

    #[Column(name: "m_grp", type: "smallint")]
    private int $mGrp;

    #[Column(name: "m_sgrp", type: "smallint")]
    private int $mSgrp;

    #[Column(name: "m_product", type: "smallint", nullable: true)]
    private ?int $mProduct;

    #[Column(name: "m_rid", type: "smallint", nullable: true)]
    private ?int $mRid;

    #[Column(name: "m_packing", type: "smallint", nullable: true)]
    private ?int $mPacking;

    #[Column(name: "m_name", type: "string", nullable: true)]
    private ?string $mName;

    #[Column(name: "quantity_a", type: "decimal")]
    private string $quantityA;

    #[Column(name: "bom_waste", type: "decimal")]
    private string $bomWaste;

    #[Column(type: "decimal", nullable: true)]
    private ?string $quantity;

    #[Column(type: "smallint", nullable: true)]
    private ?int $method;

    #[Column(type: "smallint", nullable: true)]
    private ?int $unit;

    #[Column(name: "gross_nett", type: "integer")]
    private int $grossNett;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(name: "s_grp", type: "smallint")]
    private int $sGrp;

    #[Column(type: "smallint")]
    private int $product;

    #[Column(type: "string")]
    private string $rid;

    #[Column(name: "packing_type", type: "smallint")]
    private int $packingType;

    #[Column(name: "batch_no", type: "smallint", nullable: true)]
    private ?int $batchNo;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(name: "a_operator", type: "smallint")]
    private int $aOperator;

    #[Column(name: "a_datetime", type: "datetime")]
    private DateTime $aDatetime;

    #[Column(name: "pp_qty", type: "decimal")]
    private string $ppQty;

    #[Column(name: "pp_bal", type: "decimal")]
    private string $ppBal;

    #[Column(name: "pp_id", type: "string")]
    private string $ppId;

    public function __construct()
    {
        $this->method = 23;
        $this->unit = 12;
        $this->grp = (isset($_GET['GRP']))  ? $_GET['GRP'] :'';
        $this->sGrp = (isset($_GET['SGRP']))  ? $_GET['SGRP'] : '';
        $this->product = (isset($_GET['PROD']))  ? $_GET['PROD'] : '';
        $this->rid = (isset($_GET['RID']))  ? $_GET['RID'] : '';
        $this->packingType = (isset($_GET['PT']))  ? $_GET['PT'] : '';
        $this->batchNo = (isset($_GET['BN']))  ? $_GET['BN'] : '';
        $this->operator = 0;
        $this->ppBal = "0.000";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getWarpWeft(): int
    {
        return $this->warpWeft;
    }

    public function setWarpWeft(int $value): static
    {
        $this->warpWeft = $value;
        return $this;
    }

    public function getMGrp(): int
    {
        return $this->mGrp;
    }

    public function setMGrp(int $value): static
    {
        $this->mGrp = $value;
        return $this;
    }

    public function getMSgrp(): int
    {
        return $this->mSgrp;
    }

    public function setMSgrp(int $value): static
    {
        $this->mSgrp = $value;
        return $this;
    }

    public function getMProduct(): ?int
    {
        return $this->mProduct;
    }

    public function setMProduct(?int $value): static
    {
        $this->mProduct = $value;
        return $this;
    }

    public function getMRid(): ?int
    {
        return $this->mRid;
    }

    public function setMRid(?int $value): static
    {
        $this->mRid = $value;
        return $this;
    }

    public function getMPacking(): ?int
    {
        return $this->mPacking;
    }

    public function setMPacking(?int $value): static
    {
        $this->mPacking = $value;
        return $this;
    }

    public function getMName(): ?string
    {
        return HtmlDecode($this->mName);
    }

    public function setMName(?string $value): static
    {
        $this->mName = RemoveXss($value);
        return $this;
    }

    public function getQuantityA(): string
    {
        return $this->quantityA;
    }

    public function setQuantityA(string $value): static
    {
        $this->quantityA = $value;
        return $this;
    }

    public function getBomWaste(): string
    {
        return $this->bomWaste;
    }

    public function setBomWaste(string $value): static
    {
        $this->bomWaste = $value;
        return $this;
    }

    public function getQuantity(): ?string
    {
        return $this->quantity;
    }

    public function setQuantity(?string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getMethod(): ?int
    {
        return $this->method;
    }

    public function setMethod(?int $value): static
    {
        $this->method = $value;
        return $this;
    }

    public function getUnit(): ?int
    {
        return $this->unit;
    }

    public function setUnit(?int $value): static
    {
        $this->unit = $value;
        return $this;
    }

    public function getGrossNett(): int
    {
        return $this->grossNett;
    }

    public function setGrossNett(int $value): static
    {
        $this->grossNett = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): int
    {
        return $this->product;
    }

    public function setProduct(int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRid(): string
    {
        return HtmlDecode($this->rid);
    }

    public function setRid(string $value): static
    {
        $this->rid = RemoveXss($value);
        return $this;
    }

    public function getPackingType(): int
    {
        return $this->packingType;
    }

    public function setPackingType(int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getBatchNo(): ?int
    {
        return $this->batchNo;
    }

    public function setBatchNo(?int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getAOperator(): int
    {
        return $this->aOperator;
    }

    public function setAOperator(int $value): static
    {
        $this->aOperator = $value;
        return $this;
    }

    public function getADatetime(): DateTime
    {
        return $this->aDatetime;
    }

    public function setADatetime(DateTime $value): static
    {
        $this->aDatetime = $value;
        return $this;
    }

    public function getPpQty(): string
    {
        return $this->ppQty;
    }

    public function setPpQty(string $value): static
    {
        $this->ppQty = $value;
        return $this;
    }

    public function getPpBal(): string
    {
        return $this->ppBal;
    }

    public function setPpBal(string $value): static
    {
        $this->ppBal = $value;
        return $this;
    }

    public function getPpId(): string
    {
        return HtmlDecode($this->ppId);
    }

    public function setPpId(string $value): static
    {
        $this->ppId = RemoveXss($value);
        return $this;
    }
}
