<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "blending_table" table
 */
#[Entity]
#[Table(name: "blending_table")]
class BlendingTable extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string", nullable: true)]
    private ?string $ref;

    #[Column(name: "out_ref", type: "smallint")]
    private int $outRef;

    #[Column(type: "smallint")]
    private int $product;

    #[Column(type: "smallint")]
    private int $rid;

    #[Column(name: "tmp_lot", type: "string")]
    private string $tmpLot;

    #[Column(type: "smallint", nullable: true)]
    private ?int $packets;

    #[Column(type: "decimal", nullable: true)]
    private ?string $quantity;

    #[Column(name: "par_com", type: "integer")]
    private int $parCom;

    #[Column(name: "packing_type", type: "integer", nullable: true)]
    private ?int $packingType;

    #[Column(type: "integer", nullable: true)]
    private ?int $godown;

    #[Column(type: "date", nullable: true)]
    private ?DateTime $dated;

    #[Column(name: "employee_id", type: "string")]
    private string $employeeId;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    public function __construct()
    {
        $this->parCom = 1;
        $this->packingType = 3;
        $this->employeeId = "1000";
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getRef(): ?string
    {
        return HtmlDecode($this->ref);
    }

    public function setRef(?string $value): static
    {
        $this->ref = RemoveXss($value);
        return $this;
    }

    public function getOutRef(): int
    {
        return $this->outRef;
    }

    public function setOutRef(int $value): static
    {
        $this->outRef = $value;
        return $this;
    }

    public function getProduct(): int
    {
        return $this->product;
    }

    public function setProduct(int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRid(): int
    {
        return $this->rid;
    }

    public function setRid(int $value): static
    {
        $this->rid = $value;
        return $this;
    }

    public function getTmpLot(): string
    {
        return HtmlDecode($this->tmpLot);
    }

    public function setTmpLot(string $value): static
    {
        $this->tmpLot = RemoveXss($value);
        return $this;
    }

    public function getPackets(): ?int
    {
        return $this->packets;
    }

    public function setPackets(?int $value): static
    {
        $this->packets = $value;
        return $this;
    }

    public function getQuantity(): ?string
    {
        return $this->quantity;
    }

    public function setQuantity(?string $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getParCom(): int
    {
        return $this->parCom;
    }

    public function setParCom(int $value): static
    {
        $this->parCom = $value;
        return $this;
    }

    public function getPackingType(): ?int
    {
        return $this->packingType;
    }

    public function setPackingType(?int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getGodown(): ?int
    {
        return $this->godown;
    }

    public function setGodown(?int $value): static
    {
        $this->godown = $value;
        return $this;
    }

    public function getDated(): ?DateTime
    {
        return $this->dated;
    }

    public function setDated(?DateTime $value): static
    {
        $this->dated = $value;
        return $this;
    }

    public function getEmployeeId(): string
    {
        return HtmlDecode($this->employeeId);
    }

    public function setEmployeeId(string $value): static
    {
        $this->employeeId = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }
}
