<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "bcode_token" table
 */
#[Entity]
#[Table(name: "bcode_token")]
class BcodeToken extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "integer", nullable: true)]
    private ?int $po;

    #[Column(type: "integer")]
    private int $barcode;

    #[Column(name: "buyer_uid", type: "string", nullable: true)]
    private ?string $buyerUid;

    #[Column(name: "design_id", type: "string", nullable: true)]
    private ?string $designId;

    #[Column(name: "size_cm", type: "string")]
    private string $sizeCm;

    #[Column(name: "weaving_works", type: "smallint")]
    private int $weavingWorks;

    public function __construct()
    {
        $this->barcode = 0;
        $this->weavingWorks = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getBarcode(): int
    {
        return $this->barcode;
    }

    public function setBarcode(int $value): static
    {
        $this->barcode = $value;
        return $this;
    }

    public function getBuyerUid(): ?string
    {
        return HtmlDecode($this->buyerUid);
    }

    public function setBuyerUid(?string $value): static
    {
        $this->buyerUid = RemoveXss($value);
        return $this;
    }

    public function getDesignId(): ?string
    {
        return HtmlDecode($this->designId);
    }

    public function setDesignId(?string $value): static
    {
        $this->designId = RemoveXss($value);
        return $this;
    }

    public function getSizeCm(): string
    {
        return HtmlDecode($this->sizeCm);
    }

    public function setSizeCm(string $value): static
    {
        $this->sizeCm = RemoveXss($value);
        return $this;
    }

    public function getWeavingWorks(): int
    {
        return $this->weavingWorks;
    }

    public function setWeavingWorks(int $value): static
    {
        $this->weavingWorks = $value;
        return $this;
    }
}
