<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "bcode_p_remarks" table
 */
#[Entity]
#[Table(name: "bcode_p_remarks")]
class BcodePRemark extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer")]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "integer")]
    private int $barcode;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "p_remarks", type: "string", nullable: true)]
    private ?string $pRemarks;

    #[Column(name: "buyers_id", type: "integer", nullable: true)]
    private ?int $buyersId;

    #[Column(name: "design_id", type: "string", nullable: true)]
    private ?string $designId;

    #[Column(name: "size_cm", type: "string")]
    private string $sizeCm;

    #[Column(name: "size_buyer", type: "string", nullable: true)]
    private ?string $sizeBuyer;

    public function __construct()
    {
        $this->barcode = 99999;
        $this->pRemarks = "--NA--";
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getBarcode(): int
    {
        return $this->barcode;
    }

    public function setBarcode(int $value): static
    {
        $this->barcode = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getPRemarks(): ?string
    {
        return HtmlDecode($this->pRemarks);
    }

    public function setPRemarks(?string $value): static
    {
        $this->pRemarks = RemoveXss($value);
        return $this;
    }

    public function getBuyersId(): ?int
    {
        return $this->buyersId;
    }

    public function setBuyersId(?int $value): static
    {
        $this->buyersId = $value;
        return $this;
    }

    public function getDesignId(): ?string
    {
        return HtmlDecode($this->designId);
    }

    public function setDesignId(?string $value): static
    {
        $this->designId = RemoveXss($value);
        return $this;
    }

    public function getSizeCm(): string
    {
        return HtmlDecode($this->sizeCm);
    }

    public function setSizeCm(string $value): static
    {
        $this->sizeCm = RemoveXss($value);
        return $this;
    }

    public function getSizeBuyer(): ?string
    {
        return HtmlDecode($this->sizeBuyer);
    }

    public function setSizeBuyer(?string $value): static
    {
        $this->sizeBuyer = RemoveXss($value);
        return $this;
    }
}
