<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "bcode_s" table
 */
#[Entity]
#[Table(name: "bcode_s")]
class Bcode extends AbstractEntity
{
    #[Id]
    #[Column(type: "integer", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint", nullable: true)]
    private ?int $po;

    #[Column(type: "integer", unique: true)]
    private int $barcode;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "smallint", nullable: true)]
    private ?int $pid;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(name: "weaving_works", type: "smallint")]
    private int $weavingWorks;

    #[Column(name: "current_works", type: "smallint")]
    private int $currentWorks;

    #[Column(name: "buyers_id", type: "integer", nullable: true)]
    private ?int $buyersId;

    #[Column(name: "buyer_ref", type: "string", nullable: true)]
    private ?string $buyerRef;

    #[Column(name: "buyer_tid", type: "string", nullable: true)]
    private ?string $buyerTid;

    #[Column(type: "string", nullable: true)]
    private ?string $design;

    #[Column(name: "design_id", type: "string", nullable: true)]
    private ?string $designId;

    #[Column(name: "batch_no", type: "smallint", nullable: true)]
    private ?int $batchNo;

    #[Column(name: "l_cm", type: "smallint", nullable: true)]
    private ?int $lCm;

    #[Column(name: "w_cm", type: "smallint", nullable: true)]
    private ?int $wCm;

    #[Column(type: "float")]
    private float $sqm;

    #[Column(name: "sqm_a", type: "float")]
    private float $sqmA;

    #[Column(type: "float")]
    private float $2srm;

    #[Column(name: "`2srm_a`", options: ["name" => "2srm_a"], type: "float")]
    private float $2srmA;

    #[Column(type: "float")]
    private float $4srm;

    #[Column(name: "`4srm_a`", options: ["name" => "4srm_a"], type: "float")]
    private float $4srmA;

    #[Column(type: "integer")]
    private int $shape;

    #[Column(name: "product_type", type: "smallint")]
    private int $productType;

    #[Column(name: "size_cm", type: "string")]
    private string $sizeCm;

    #[Column(name: "size_buyer", type: "string", nullable: true)]
    private ?string $sizeBuyer;

    #[Column(name: "buyer_uid", type: "string", nullable: true)]
    private ?string $buyerUid;

    #[Column(type: "smallint", nullable: true)]
    private ?int $quantity;

    #[Column(name: "po_price", type: "string", nullable: true)]
    private ?string $poPrice;

    #[Column(name: "despatch_week", type: "smallint", nullable: true)]
    private ?int $despatchWeek;

    #[Column(name: "despatch_date", type: "date")]
    private DateTime $despatchDate;

    #[Column(name: "payment_plan", type: "smallint", nullable: true)]
    private ?int $paymentPlan;

    #[Column(name: "production_plan", type: "integer", nullable: true)]
    private ?int $productionPlan;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "integer", nullable: true)]
    private ?int $completed;

    #[Column(name: "buyer_po", type: "string", nullable: true)]
    private ?string $buyerPo;

    #[Column(name: "jc_no", type: "integer")]
    private int $jcNo;

    #[Column(name: "pp_id", type: "integer", nullable: true)]
    private ?int $ppId;

    #[Column(name: "in_id", type: "integer", nullable: true)]
    private ?int $inId;

    #[Column(name: "out_id", type: "integer", nullable: true)]
    private ?int $outId;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    public function __construct()
    {
        $this->barcode = 0;
        $this->operator = 0;
        $this->weavingWorks = 0;
        $this->currentWorks = 0;
        $this->status = 0;
        $this->completed = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getBarcode(): int
    {
        return $this->barcode;
    }

    public function setBarcode(int $value): static
    {
        $this->barcode = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getPid(): ?int
    {
        return $this->pid;
    }

    public function setPid(?int $value): static
    {
        $this->pid = $value;
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getWeavingWorks(): int
    {
        return $this->weavingWorks;
    }

    public function setWeavingWorks(int $value): static
    {
        $this->weavingWorks = $value;
        return $this;
    }

    public function getCurrentWorks(): int
    {
        return $this->currentWorks;
    }

    public function setCurrentWorks(int $value): static
    {
        $this->currentWorks = $value;
        return $this;
    }

    public function getBuyersId(): ?int
    {
        return $this->buyersId;
    }

    public function setBuyersId(?int $value): static
    {
        $this->buyersId = $value;
        return $this;
    }

    public function getBuyerRef(): ?string
    {
        return HtmlDecode($this->buyerRef);
    }

    public function setBuyerRef(?string $value): static
    {
        $this->buyerRef = RemoveXss($value);
        return $this;
    }

    public function getBuyerTid(): ?string
    {
        return HtmlDecode($this->buyerTid);
    }

    public function setBuyerTid(?string $value): static
    {
        $this->buyerTid = RemoveXss($value);
        return $this;
    }

    public function getDesign(): ?string
    {
        return HtmlDecode($this->design);
    }

    public function setDesign(?string $value): static
    {
        $this->design = RemoveXss($value);
        return $this;
    }

    public function getDesignId(): ?string
    {
        return HtmlDecode($this->designId);
    }

    public function setDesignId(?string $value): static
    {
        $this->designId = RemoveXss($value);
        return $this;
    }

    public function getBatchNo(): ?int
    {
        return $this->batchNo;
    }

    public function setBatchNo(?int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getLCm(): ?int
    {
        return $this->lCm;
    }

    public function setLCm(?int $value): static
    {
        $this->lCm = $value;
        return $this;
    }

    public function getWCm(): ?int
    {
        return $this->wCm;
    }

    public function setWCm(?int $value): static
    {
        $this->wCm = $value;
        return $this;
    }

    public function getSqm(): float
    {
        return $this->sqm;
    }

    public function setSqm(float $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getSqmA(): float
    {
        return $this->sqmA;
    }

    public function setSqmA(float $value): static
    {
        $this->sqmA = $value;
        return $this;
    }

    public function get2srm(): float
    {
        return $this->2srm;
    }

    public function set2srm(float $value): static
    {
        $this->2srm = $value;
        return $this;
    }

    public function get2srmA(): float
    {
        return $this->2srmA;
    }

    public function set2srmA(float $value): static
    {
        $this->2srmA = $value;
        return $this;
    }

    public function get4srm(): float
    {
        return $this->4srm;
    }

    public function set4srm(float $value): static
    {
        $this->4srm = $value;
        return $this;
    }

    public function get4srmA(): float
    {
        return $this->4srmA;
    }

    public function set4srmA(float $value): static
    {
        $this->4srmA = $value;
        return $this;
    }

    public function getShape(): int
    {
        return $this->shape;
    }

    public function setShape(int $value): static
    {
        $this->shape = $value;
        return $this;
    }

    public function getProductType(): int
    {
        return $this->productType;
    }

    public function setProductType(int $value): static
    {
        $this->productType = $value;
        return $this;
    }

    public function getSizeCm(): string
    {
        return HtmlDecode($this->sizeCm);
    }

    public function setSizeCm(string $value): static
    {
        $this->sizeCm = RemoveXss($value);
        return $this;
    }

    public function getSizeBuyer(): ?string
    {
        return HtmlDecode($this->sizeBuyer);
    }

    public function setSizeBuyer(?string $value): static
    {
        $this->sizeBuyer = RemoveXss($value);
        return $this;
    }

    public function getBuyerUid(): ?string
    {
        return HtmlDecode($this->buyerUid);
    }

    public function setBuyerUid(?string $value): static
    {
        $this->buyerUid = RemoveXss($value);
        return $this;
    }

    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    public function setQuantity(?int $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getPoPrice(): ?string
    {
        return HtmlDecode($this->poPrice);
    }

    public function setPoPrice(?string $value): static
    {
        $this->poPrice = RemoveXss($value);
        return $this;
    }

    public function getDespatchWeek(): ?int
    {
        return $this->despatchWeek;
    }

    public function setDespatchWeek(?int $value): static
    {
        $this->despatchWeek = $value;
        return $this;
    }

    public function getDespatchDate(): DateTime
    {
        return $this->despatchDate;
    }

    public function setDespatchDate(DateTime $value): static
    {
        $this->despatchDate = $value;
        return $this;
    }

    public function getPaymentPlan(): ?int
    {
        return $this->paymentPlan;
    }

    public function setPaymentPlan(?int $value): static
    {
        $this->paymentPlan = $value;
        return $this;
    }

    public function getProductionPlan(): ?int
    {
        return $this->productionPlan;
    }

    public function setProductionPlan(?int $value): static
    {
        $this->productionPlan = $value;
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getCompleted(): ?int
    {
        return $this->completed;
    }

    public function setCompleted(?int $value): static
    {
        $this->completed = $value;
        return $this;
    }

    public function getBuyerPo(): ?string
    {
        return HtmlDecode($this->buyerPo);
    }

    public function setBuyerPo(?string $value): static
    {
        $this->buyerPo = RemoveXss($value);
        return $this;
    }

    public function getJcNo(): int
    {
        return $this->jcNo;
    }

    public function setJcNo(int $value): static
    {
        $this->jcNo = $value;
        return $this;
    }

    public function getPpId(): ?int
    {
        return $this->ppId;
    }

    public function setPpId(?int $value): static
    {
        $this->ppId = $value;
        return $this;
    }

    public function getInId(): ?int
    {
        return $this->inId;
    }

    public function setInId(?int $value): static
    {
        $this->inId = $value;
        return $this;
    }

    public function getOutId(): ?int
    {
        return $this->outId;
    }

    public function setOutId(?int $value): static
    {
        $this->outId = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }
}
