<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "batch_no" table
 */
#[Entity]
#[Table(name: "batch_no")]
class BatchNo extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint")]
    private int $grp;

    #[Column(name: "s_grp", type: "smallint")]
    private int $sGrp;

    #[Column(type: "smallint")]
    private int $product;

    #[Column(type: "string")]
    private string $rid;

    #[Column(name: "packing_type", type: "smallint")]
    private int $packingType;

    #[Column(name: "batch_no", type: "string")]
    private string $batchNo;

    #[Column(type: "string", nullable: true)]
    private ?string $description;

    #[Column(type: "text", nullable: true)]
    private ?string $remarks;

    #[Column(type: "integer")]
    private int $status;

    #[Column(type: "string", nullable: true)]
    private ?string $image;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    #[Column(name: "a_operator", type: "smallint")]
    private int $aOperator;

    #[Column(name: "a_datetime", type: "datetime")]
    private DateTime $aDatetime;

    #[Column(type: "string", nullable: true)]
    private ?string $process;

    #[Column(name: "bom_app_id", type: "smallint")]
    private int $bomAppId;

    #[Column(name: "bom_id", type: "text", nullable: true)]
    private ?string $bomId;

    #[Column(name: "process_id", type: "text", nullable: true)]
    private ?string $processId;

    #[Column(name: "payment_id", type: "text", nullable: true)]
    private ?string $paymentId;

    #[Column(type: "string", unique: true)]
    private string $uid;

    public function __construct()
    {
        $this->grp = 3;
        $this->sGrp = 91;
        $this->packingType = 0;
        $this->status = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): int
    {
        return $this->grp;
    }

    public function setGrp(int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): int
    {
        return $this->sGrp;
    }

    public function setSGrp(int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProduct(): int
    {
        return $this->product;
    }

    public function setProduct(int $value): static
    {
        $this->product = $value;
        return $this;
    }

    public function getRid(): string
    {
        return HtmlDecode($this->rid);
    }

    public function setRid(string $value): static
    {
        $this->rid = RemoveXss($value);
        return $this;
    }

    public function getPackingType(): int
    {
        return $this->packingType;
    }

    public function setPackingType(int $value): static
    {
        $this->packingType = $value;
        return $this;
    }

    public function getBatchNo(): string
    {
        return HtmlDecode($this->batchNo);
    }

    public function setBatchNo(string $value): static
    {
        $this->batchNo = RemoveXss($value);
        return $this;
    }

    public function getDescription(): ?string
    {
        return HtmlDecode($this->description);
    }

    public function setDescription(?string $value): static
    {
        $this->description = RemoveXss($value);
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getStatus(): int
    {
        return $this->status;
    }

    public function setStatus(int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getImage(): ?string
    {
        return HtmlDecode($this->image);
    }

    public function setImage(?string $value): static
    {
        $this->image = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getAOperator(): int
    {
        return $this->aOperator;
    }

    public function setAOperator(int $value): static
    {
        $this->aOperator = $value;
        return $this;
    }

    public function getADatetime(): DateTime
    {
        return $this->aDatetime;
    }

    public function setADatetime(DateTime $value): static
    {
        $this->aDatetime = $value;
        return $this;
    }

    public function getProcess(): ?string
    {
        return HtmlDecode($this->process);
    }

    public function setProcess(?string $value): static
    {
        $this->process = RemoveXss($value);
        return $this;
    }

    public function getBomAppId(): int
    {
        return $this->bomAppId;
    }

    public function setBomAppId(int $value): static
    {
        $this->bomAppId = $value;
        return $this;
    }

    public function getBomId(): ?string
    {
        return HtmlDecode($this->bomId);
    }

    public function setBomId(?string $value): static
    {
        $this->bomId = RemoveXss($value);
        return $this;
    }

    public function getProcessId(): ?string
    {
        return HtmlDecode($this->processId);
    }

    public function setProcessId(?string $value): static
    {
        $this->processId = RemoveXss($value);
        return $this;
    }

    public function getPaymentId(): ?string
    {
        return HtmlDecode($this->paymentId);
    }

    public function setPaymentId(?string $value): static
    {
        $this->paymentId = RemoveXss($value);
        return $this;
    }

    public function getUid(): string
    {
        return HtmlDecode($this->uid);
    }

    public function setUid(string $value): static
    {
        $this->uid = RemoveXss($value);
        return $this;
    }
}
