<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "barcode_search" table
 */
#[Entity]
#[Table(name: "barcode_search")]
class BarcodeSearch extends AbstractEntity
{
    #[Column(type: "integer", nullable: true)]
    private ?int $po;

    #[Column(type: "text", nullable: true)]
    private ?string $barcode;

    #[Column(type: "string", nullable: true)]
    private ?string $design;

    #[Column(type: "string")]
    private string $size;

    #[Column(name: "batch_no", type: "smallint", nullable: true)]
    private ?int $batchNo;

    #[Column(name: "process_d", type: "text", nullable: true)]
    private ?string $processD;

    #[Column(name: "buyer_ref", type: "text", nullable: true)]
    private ?string $buyerRef;

    #[Column(name: "buyer_barcode", type: "string", nullable: true)]
    private ?string $buyerBarcode;

    #[Column(name: "dispatch_week", type: "smallint", nullable: true)]
    private ?int $dispatchWeek;

    #[Column(name: "current_works", type: "smallint")]
    private int $currentWorks;

    public function __construct()
    {
        $this->barcode = "0";
        $this->currentWorks = 0;
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getBarcode(): ?string
    {
        return HtmlDecode($this->barcode);
    }

    public function setBarcode(?string $value): static
    {
        $this->barcode = RemoveXss($value);
        return $this;
    }

    public function getDesign(): ?string
    {
        return HtmlDecode($this->design);
    }

    public function setDesign(?string $value): static
    {
        $this->design = RemoveXss($value);
        return $this;
    }

    public function getSize(): string
    {
        return HtmlDecode($this->size);
    }

    public function setSize(string $value): static
    {
        $this->size = RemoveXss($value);
        return $this;
    }

    public function getBatchNo(): ?int
    {
        return $this->batchNo;
    }

    public function setBatchNo(?int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getProcessD(): ?string
    {
        return HtmlDecode($this->processD);
    }

    public function setProcessD(?string $value): static
    {
        $this->processD = RemoveXss($value);
        return $this;
    }

    public function getBuyerRef(): ?string
    {
        return HtmlDecode($this->buyerRef);
    }

    public function setBuyerRef(?string $value): static
    {
        $this->buyerRef = RemoveXss($value);
        return $this;
    }

    public function getBuyerBarcode(): ?string
    {
        return HtmlDecode($this->buyerBarcode);
    }

    public function setBuyerBarcode(?string $value): static
    {
        $this->buyerBarcode = RemoveXss($value);
        return $this;
    }

    public function getDispatchWeek(): ?int
    {
        return $this->dispatchWeek;
    }

    public function setDispatchWeek(?int $value): static
    {
        $this->dispatchWeek = $value;
        return $this;
    }

    public function getCurrentWorks(): int
    {
        return $this->currentWorks;
    }

    public function setCurrentWorks(int $value): static
    {
        $this->currentWorks = $value;
        return $this;
    }
}
