<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "barcode_in_process" table
 */
#[Entity]
#[Table(name: "barcode_in_process")]
class BarcodeInProcess extends AbstractEntity
{
    #[Column(type: "integer")]
    private int $barcode;

    #[Column(type: "string", nullable: true)]
    private ?string $design;

    #[Column(name: "design_id", type: "string", nullable: true)]
    private ?string $designId;

    #[Column(name: "size_cm", type: "string")]
    private string $sizeCm;

    #[Column(name: "process_d", type: "integer")]
    private int $processD;

    #[Column(type: "text")]
    private string $process;

    #[Column(name: "buyers_id", type: "integer", nullable: true)]
    private ?int $buyersId;

    public function __construct()
    {
        $this->barcode = 0;
        $this->processD = 0;
    }

    public function getBarcode(): int
    {
        return $this->barcode;
    }

    public function setBarcode(int $value): static
    {
        $this->barcode = $value;
        return $this;
    }

    public function getDesign(): ?string
    {
        return HtmlDecode($this->design);
    }

    public function setDesign(?string $value): static
    {
        $this->design = RemoveXss($value);
        return $this;
    }

    public function getDesignId(): ?string
    {
        return HtmlDecode($this->designId);
    }

    public function setDesignId(?string $value): static
    {
        $this->designId = RemoveXss($value);
        return $this;
    }

    public function getSizeCm(): string
    {
        return HtmlDecode($this->sizeCm);
    }

    public function setSizeCm(string $value): static
    {
        $this->sizeCm = RemoveXss($value);
        return $this;
    }

    public function getProcessD(): int
    {
        return $this->processD;
    }

    public function setProcessD(int $value): static
    {
        $this->processD = $value;
        return $this;
    }

    public function getProcess(): string
    {
        return HtmlDecode($this->process);
    }

    public function setProcess(string $value): static
    {
        $this->process = RemoveXss($value);
        return $this;
    }

    public function getBuyersId(): ?int
    {
        return $this->buyersId;
    }

    public function setBuyersId(?int $value): static
    {
        $this->buyersId = $value;
        return $this;
    }
}
