<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "barcode" table
 */
#[Entity]
#[Table(name: "barcode")]
class Barcode extends AbstractEntity
{
    #[Column(type: "integer", nullable: true)]
    private ?int $po;

    #[Column(type: "integer")]
    private int $barcode;

    #[Column(name: "batch_no", type: "smallint", nullable: true)]
    private ?int $batchNo;

    #[Column(name: "size_cm", type: "string")]
    private string $sizeCm;

    #[Column(type: "decimal")]
    private string $sqm;

    #[Column(name: "sqm_a", type: "float")]
    private float $sqmA;

    #[Column(type: "decimal", nullable: true)]
    private ?string $weight;

    #[Column(type: "smallint", nullable: true)]
    private ?int $quantity;

    #[Column(name: "jc_no", type: "integer")]
    private int $jcNo;

    #[Column(name: "process_c", type: "string", nullable: true)]
    private ?string $processC;

    #[Column(name: "process_d", type: "string", nullable: true)]
    private ?string $processD;

    #[Column(type: "smallint", nullable: true)]
    private ?int $status;

    #[Column(name: "buyers_id", type: "integer", nullable: true)]
    private ?int $buyersId;

    #[Column(name: "despatch_week", type: "smallint", nullable: true)]
    private ?int $despatchWeek;

    #[Column(type: "integer")]
    private int $cs;

    #[Column(name: "weaving_works", type: "smallint")]
    private int $weavingWorks;

    #[Column(name: "current_works", type: "smallint")]
    private int $currentWorks;

    #[Column(type: "string", nullable: true)]
    private ?string $remarks;

    #[Column(name: "p_remarks", type: "string", nullable: true)]
    private ?string $pRemarks;

    #[Column(name: "buyer_po", type: "string", nullable: true)]
    private ?string $buyerPo;

    #[Column(name: "buyer_ref", type: "smallint", nullable: true)]
    private ?int $buyerRef;

    #[Column(name: "design_size", type: "string", nullable: true)]
    private ?string $designSize;

    #[Column(name: "buyer_uid", type: "string", nullable: true)]
    private ?string $buyerUid;

    #[Column(name: "buyer_loc", type: "string")]
    private string $buyerLoc;

    #[Column(name: "order_date", type: "date", nullable: true)]
    private ?DateTime $orderDate;

    #[Column(type: "integer", nullable: true)]
    private ?int $completed;

    #[Column(type: "string")]
    private string $category;

    #[Column(name: "pl_no", type: "decimal")]
    private string $plNo;

    #[Column(name: "design_id", type: "string", nullable: true)]
    private ?string $designId;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    #[Column(type: "string", nullable: true)]
    private ?string $process;

    #[Id]
    #[Column(type: "integer")]
    private int $id;

    #[Column(type: "decimal", nullable: true)]
    private ?string $pid;

    #[Column(type: "integer")]
    private int $shape;

    #[Column(name: "production_plan", type: "integer", nullable: true)]
    private ?int $productionPlan;

    #[Column(type: "float")]
    private float $2srm;

    #[Column(type: "float")]
    private float $4srm;

    #[Column(name: "RefID", type: "string", nullable: true)]
    private ?string $refId;

    #[Column(name: "buyer_tid", type: "string", nullable: true)]
    private ?string $buyerTid;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "s_grp", type: "smallint", nullable: true)]
    private ?int $sGrp;

    #[Column(name: "product_type", type: "smallint")]
    private int $productType;

    #[Column(name: "w_cm", type: "smallint", nullable: true)]
    private ?int $wCm;

    #[Column(name: "l_cm", type: "smallint", nullable: true)]
    private ?int $lCm;

    #[Column(name: "`2srm_a`", options: ["name" => "2srm_a"], type: "float")]
    private float $2srmA;

    #[Column(name: "`4srm_a`", options: ["name" => "4srm_a"], type: "float")]
    private float $4srmA;

    #[Column(name: "buyer_barcode", type: "string", nullable: true)]
    private ?string $buyerBarcode;

    public function __construct()
    {
        $this->barcode = 0;
        $this->status = 0;
        $this->cs = 0;
        $this->weavingWorks = 0;
        $this->currentWorks = 0;
        $this->pRemarks = "--NA--";
        $this->buyerLoc = "0";
        $this->completed = 0;
        $this->plNo = "0.00";
        $this->operator = 0;
    }

    public function getPo(): ?int
    {
        return $this->po;
    }

    public function setPo(?int $value): static
    {
        $this->po = $value;
        return $this;
    }

    public function getBarcode(): int
    {
        return $this->barcode;
    }

    public function setBarcode(int $value): static
    {
        $this->barcode = $value;
        return $this;
    }

    public function getBatchNo(): ?int
    {
        return $this->batchNo;
    }

    public function setBatchNo(?int $value): static
    {
        $this->batchNo = $value;
        return $this;
    }

    public function getSizeCm(): string
    {
        return HtmlDecode($this->sizeCm);
    }

    public function setSizeCm(string $value): static
    {
        $this->sizeCm = RemoveXss($value);
        return $this;
    }

    public function getSqm(): string
    {
        return $this->sqm;
    }

    public function setSqm(string $value): static
    {
        $this->sqm = $value;
        return $this;
    }

    public function getSqmA(): float
    {
        return $this->sqmA;
    }

    public function setSqmA(float $value): static
    {
        $this->sqmA = $value;
        return $this;
    }

    public function getWeight(): ?string
    {
        return $this->weight;
    }

    public function setWeight(?string $value): static
    {
        $this->weight = $value;
        return $this;
    }

    public function getQuantity(): ?int
    {
        return $this->quantity;
    }

    public function setQuantity(?int $value): static
    {
        $this->quantity = $value;
        return $this;
    }

    public function getJcNo(): int
    {
        return $this->jcNo;
    }

    public function setJcNo(int $value): static
    {
        $this->jcNo = $value;
        return $this;
    }

    public function getProcessC(): ?string
    {
        return HtmlDecode($this->processC);
    }

    public function setProcessC(?string $value): static
    {
        $this->processC = RemoveXss($value);
        return $this;
    }

    public function getProcessD(): ?string
    {
        return HtmlDecode($this->processD);
    }

    public function setProcessD(?string $value): static
    {
        $this->processD = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getBuyersId(): ?int
    {
        return $this->buyersId;
    }

    public function setBuyersId(?int $value): static
    {
        $this->buyersId = $value;
        return $this;
    }

    public function getDespatchWeek(): ?int
    {
        return $this->despatchWeek;
    }

    public function setDespatchWeek(?int $value): static
    {
        $this->despatchWeek = $value;
        return $this;
    }

    public function getCs(): int
    {
        return $this->cs;
    }

    public function setCs(int $value): static
    {
        $this->cs = $value;
        return $this;
    }

    public function getWeavingWorks(): int
    {
        return $this->weavingWorks;
    }

    public function setWeavingWorks(int $value): static
    {
        $this->weavingWorks = $value;
        return $this;
    }

    public function getCurrentWorks(): int
    {
        return $this->currentWorks;
    }

    public function setCurrentWorks(int $value): static
    {
        $this->currentWorks = $value;
        return $this;
    }

    public function getRemarks(): ?string
    {
        return HtmlDecode($this->remarks);
    }

    public function setRemarks(?string $value): static
    {
        $this->remarks = RemoveXss($value);
        return $this;
    }

    public function getPRemarks(): ?string
    {
        return HtmlDecode($this->pRemarks);
    }

    public function setPRemarks(?string $value): static
    {
        $this->pRemarks = RemoveXss($value);
        return $this;
    }

    public function getBuyerPo(): ?string
    {
        return HtmlDecode($this->buyerPo);
    }

    public function setBuyerPo(?string $value): static
    {
        $this->buyerPo = RemoveXss($value);
        return $this;
    }

    public function getBuyerRef(): ?int
    {
        return $this->buyerRef;
    }

    public function setBuyerRef(?int $value): static
    {
        $this->buyerRef = $value;
        return $this;
    }

    public function getDesignSize(): ?string
    {
        return HtmlDecode($this->designSize);
    }

    public function setDesignSize(?string $value): static
    {
        $this->designSize = RemoveXss($value);
        return $this;
    }

    public function getBuyerUid(): ?string
    {
        return HtmlDecode($this->buyerUid);
    }

    public function setBuyerUid(?string $value): static
    {
        $this->buyerUid = RemoveXss($value);
        return $this;
    }

    public function getBuyerLoc(): string
    {
        return HtmlDecode($this->buyerLoc);
    }

    public function setBuyerLoc(string $value): static
    {
        $this->buyerLoc = RemoveXss($value);
        return $this;
    }

    public function getOrderDate(): ?DateTime
    {
        return $this->orderDate;
    }

    public function setOrderDate(?DateTime $value): static
    {
        $this->orderDate = $value;
        return $this;
    }

    public function getCompleted(): ?int
    {
        return $this->completed;
    }

    public function setCompleted(?int $value): static
    {
        $this->completed = $value;
        return $this;
    }

    public function getCategory(): string
    {
        return HtmlDecode($this->category);
    }

    public function setCategory(string $value): static
    {
        $this->category = RemoveXss($value);
        return $this;
    }

    public function getPlNo(): string
    {
        return $this->plNo;
    }

    public function setPlNo(string $value): static
    {
        $this->plNo = $value;
        return $this;
    }

    public function getDesignId(): ?string
    {
        return HtmlDecode($this->designId);
    }

    public function setDesignId(?string $value): static
    {
        $this->designId = RemoveXss($value);
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }

    public function getProcess(): ?string
    {
        return HtmlDecode($this->process);
    }

    public function setProcess(?string $value): static
    {
        $this->process = RemoveXss($value);
        return $this;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getPid(): ?string
    {
        return $this->pid;
    }

    public function setPid(?string $value): static
    {
        $this->pid = $value;
        return $this;
    }

    public function getShape(): int
    {
        return $this->shape;
    }

    public function setShape(int $value): static
    {
        $this->shape = $value;
        return $this;
    }

    public function getProductionPlan(): ?int
    {
        return $this->productionPlan;
    }

    public function setProductionPlan(?int $value): static
    {
        $this->productionPlan = $value;
        return $this;
    }

    public function get2srm(): float
    {
        return $this->2srm;
    }

    public function set2srm(float $value): static
    {
        $this->2srm = $value;
        return $this;
    }

    public function get4srm(): float
    {
        return $this->4srm;
    }

    public function set4srm(float $value): static
    {
        $this->4srm = $value;
        return $this;
    }

    public function getRefId(): ?string
    {
        return HtmlDecode($this->refId);
    }

    public function setRefId(?string $value): static
    {
        $this->refId = RemoveXss($value);
        return $this;
    }

    public function getBuyerTid(): ?string
    {
        return HtmlDecode($this->buyerTid);
    }

    public function setBuyerTid(?string $value): static
    {
        $this->buyerTid = RemoveXss($value);
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getSGrp(): ?int
    {
        return $this->sGrp;
    }

    public function setSGrp(?int $value): static
    {
        $this->sGrp = $value;
        return $this;
    }

    public function getProductType(): int
    {
        return $this->productType;
    }

    public function setProductType(int $value): static
    {
        $this->productType = $value;
        return $this;
    }

    public function getWCm(): ?int
    {
        return $this->wCm;
    }

    public function setWCm(?int $value): static
    {
        $this->wCm = $value;
        return $this;
    }

    public function getLCm(): ?int
    {
        return $this->lCm;
    }

    public function setLCm(?int $value): static
    {
        $this->lCm = $value;
        return $this;
    }

    public function get2srmA(): float
    {
        return $this->2srmA;
    }

    public function set2srmA(float $value): static
    {
        $this->2srmA = $value;
        return $this;
    }

    public function get4srmA(): float
    {
        return $this->4srmA;
    }

    public function set4srmA(float $value): static
    {
        $this->4srmA = $value;
        return $this;
    }

    public function getBuyerBarcode(): ?string
    {
        return HtmlDecode($this->buyerBarcode);
    }

    public function setBuyerBarcode(?string $value): static
    {
        $this->buyerBarcode = RemoveXss($value);
        return $this;
    }
}
