<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "banner" table
 */
#[Entity]
#[Table(name: "banner")]
class Banner extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "string")]
    private string $title;

    #[Column(type: "string", nullable: true)]
    private ?string $images;

    #[Column(type: "string")]
    private string $url;

    #[Column(name: "show_at", type: "integer")]
    private int $showAt;

    #[Column(type: "string")]
    private string $text;

    #[Column(type: "integer")]
    private int $day;

    #[Column(name: "start_time", type: "datetime")]
    private DateTime $startTime;

    #[Column(name: "end_time", type: "datetime")]
    private DateTime $endTime;

    #[Column(name: "order_by", type: "integer")]
    private int $orderBy;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime")]
    private DateTime $datetime;

    public function __construct()
    {
        $this->status = 0;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getTitle(): string
    {
        return HtmlDecode($this->title);
    }

    public function setTitle(string $value): static
    {
        $this->title = RemoveXss($value);
        return $this;
    }

    public function getImages(): ?string
    {
        return HtmlDecode($this->images);
    }

    public function setImages(?string $value): static
    {
        $this->images = RemoveXss($value);
        return $this;
    }

    public function getUrl(): string
    {
        return HtmlDecode($this->url);
    }

    public function setUrl(string $value): static
    {
        $this->url = RemoveXss($value);
        return $this;
    }

    public function getShowAt(): int
    {
        return $this->showAt;
    }

    public function setShowAt(int $value): static
    {
        $this->showAt = $value;
        return $this;
    }

    public function getText(): string
    {
        return HtmlDecode($this->text);
    }

    public function setText(string $value): static
    {
        $this->text = RemoveXss($value);
        return $this;
    }

    public function getDay(): int
    {
        return $this->day;
    }

    public function setDay(int $value): static
    {
        $this->day = $value;
        return $this;
    }

    public function getStartTime(): DateTime
    {
        return $this->startTime;
    }

    public function setStartTime(DateTime $value): static
    {
        $this->startTime = $value;
        return $this;
    }

    public function getEndTime(): DateTime
    {
        return $this->endTime;
    }

    public function setEndTime(DateTime $value): static
    {
        $this->endTime = $value;
        return $this;
    }

    public function getOrderBy(): int
    {
        return $this->orderBy;
    }

    public function setOrderBy(int $value): static
    {
        $this->orderBy = $value;
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
