<?php

namespace PHPMaker2024\fibre\Entity;

use DateTime;
use DateTimeImmutable;
use DateInterval;
use Doctrine\ORM\Mapping\Column;
use Doctrine\ORM\Mapping\Entity;
use Doctrine\ORM\Mapping\GeneratedValue;
use Doctrine\ORM\Mapping\Id;
use Doctrine\ORM\Mapping\Table;
use Doctrine\ORM\Mapping\SequenceGenerator;
use Doctrine\DBAL\Types\Types;
use PHPMaker2024\fibre\AbstractEntity;
use PHPMaker2024\fibre\AdvancedSecurity;
use PHPMaker2024\fibre\UserProfile;
use function PHPMaker2024\fibre\Config;
use function PHPMaker2024\fibre\EntityManager;
use function PHPMaker2024\fibre\RemoveXss;
use function PHPMaker2024\fibre\HtmlDecode;
use function PHPMaker2024\fibre\EncryptPassword;

/**
 * Entity class for "bank_info" table
 */
#[Entity]
#[Table(name: "bank_info")]
class BankInfo extends AbstractEntity
{
    #[Id]
    #[Column(type: "smallint", unique: true)]
    #[GeneratedValue]
    private int $id;

    #[Column(type: "smallint", nullable: true)]
    private ?int $grp;

    #[Column(name: "user_id", type: "smallint")]
    private int $userId;

    #[Column(name: "account_holder_name", type: "string", nullable: true)]
    private ?string $accountHolderName;

    #[Column(type: "smallint", nullable: true)]
    private ?int $currency;

    #[Column(name: "bank_name", type: "string", nullable: true)]
    private ?string $bankName;

    #[Column(name: "account_no", type: "string", unique: true, nullable: true)]
    private ?string $accountNo;

    #[Column(name: "c_account_no", type: "string", nullable: true)]
    private ?string $cAccountNo;

    #[Column(type: "string", nullable: true)]
    private ?string $address;

    #[Column(type: "string", nullable: true)]
    private ?string $ifsc;

    #[Column(type: "string", nullable: true)]
    private ?string $swift;

    #[Column(type: "string", nullable: true)]
    private ?string $ad;

    #[Column(type: "string", nullable: true)]
    private ?string $routing;

    #[Column(name: "routing_swift", type: "string", nullable: true)]
    private ?string $routingSwift;

    #[Column(name: "nostro_account", type: "string", nullable: true)]
    private ?string $nostroAccount;

    #[Column(type: "string", nullable: true)]
    private ?string $upi;

    #[Column(type: "integer", nullable: true)]
    private ?int $status;

    #[Column(type: "smallint", nullable: true)]
    private ?int $operator;

    #[Column(type: "datetime", nullable: true)]
    private ?DateTime $datetime;

    public function __construct()
    {
        $this->status = 1;
        $this->operator = 0;
    }

    public function getId(): int
    {
        return $this->id;
    }

    public function setId(int $value): static
    {
        $this->id = $value;
        return $this;
    }

    public function getGrp(): ?int
    {
        return $this->grp;
    }

    public function setGrp(?int $value): static
    {
        $this->grp = $value;
        return $this;
    }

    public function getUserId(): int
    {
        return $this->userId;
    }

    public function setUserId(int $value): static
    {
        $this->userId = $value;
        return $this;
    }

    public function getAccountHolderName(): ?string
    {
        return HtmlDecode($this->accountHolderName);
    }

    public function setAccountHolderName(?string $value): static
    {
        $this->accountHolderName = RemoveXss($value);
        return $this;
    }

    public function getCurrency(): ?int
    {
        return $this->currency;
    }

    public function setCurrency(?int $value): static
    {
        $this->currency = $value;
        return $this;
    }

    public function getBankName(): ?string
    {
        return HtmlDecode($this->bankName);
    }

    public function setBankName(?string $value): static
    {
        $this->bankName = RemoveXss($value);
        return $this;
    }

    public function getAccountNo(): ?string
    {
        return HtmlDecode($this->accountNo);
    }

    public function setAccountNo(?string $value): static
    {
        $this->accountNo = RemoveXss($value);
        return $this;
    }

    public function getCAccountNo(): ?string
    {
        return HtmlDecode($this->cAccountNo);
    }

    public function setCAccountNo(?string $value): static
    {
        $this->cAccountNo = RemoveXss($value);
        return $this;
    }

    public function getAddress(): ?string
    {
        return HtmlDecode($this->address);
    }

    public function setAddress(?string $value): static
    {
        $this->address = RemoveXss($value);
        return $this;
    }

    public function getIfsc(): ?string
    {
        return HtmlDecode($this->ifsc);
    }

    public function setIfsc(?string $value): static
    {
        $this->ifsc = RemoveXss($value);
        return $this;
    }

    public function getSwift(): ?string
    {
        return HtmlDecode($this->swift);
    }

    public function setSwift(?string $value): static
    {
        $this->swift = RemoveXss($value);
        return $this;
    }

    public function getAd(): ?string
    {
        return HtmlDecode($this->ad);
    }

    public function setAd(?string $value): static
    {
        $this->ad = RemoveXss($value);
        return $this;
    }

    public function getRouting(): ?string
    {
        return HtmlDecode($this->routing);
    }

    public function setRouting(?string $value): static
    {
        $this->routing = RemoveXss($value);
        return $this;
    }

    public function getRoutingSwift(): ?string
    {
        return HtmlDecode($this->routingSwift);
    }

    public function setRoutingSwift(?string $value): static
    {
        $this->routingSwift = RemoveXss($value);
        return $this;
    }

    public function getNostroAccount(): ?string
    {
        return HtmlDecode($this->nostroAccount);
    }

    public function setNostroAccount(?string $value): static
    {
        $this->nostroAccount = RemoveXss($value);
        return $this;
    }

    public function getUpi(): ?string
    {
        return HtmlDecode($this->upi);
    }

    public function setUpi(?string $value): static
    {
        $this->upi = RemoveXss($value);
        return $this;
    }

    public function getStatus(): ?int
    {
        return $this->status;
    }

    public function setStatus(?int $value): static
    {
        $this->status = $value;
        return $this;
    }

    public function getOperator(): ?int
    {
        return $this->operator;
    }

    public function setOperator(?int $value): static
    {
        $this->operator = $value;
        return $this;
    }

    public function getDatetime(): ?DateTime
    {
        return $this->datetime;
    }

    public function setDatetime(?DateTime $value): static
    {
        $this->datetime = $value;
        return $this;
    }
}
